/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.reload.event.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.xiaoyu233.fml.reload.event.recipe.RecipeModifier;
import net.xiaoyu233.fml.reload.event.recipe.RecipeType;

public class ShapelessRecipeModifier
implements RecipeModifier {
    private final ItemStack targetItem;
    private final List<ItemStack> ingredients;
    private final boolean includeInLowestCraftingDifficultyDetermination;
    private final Optional<Float> craftingDifficulty;

    public ShapelessRecipeModifier(ItemStack targetItem, List<ItemStack> ingredients, boolean includeInLowestCraftingDifficultyDetermination, Optional<Float> craftingDifficulty) {
        this.targetItem = targetItem;
        this.ingredients = ingredients;
        this.includeInLowestCraftingDifficultyDetermination = includeInLowestCraftingDifficultyDetermination;
        this.craftingDifficulty = craftingDifficulty;
    }

    @Override
    public ItemStack getOutput() {
        return this.targetItem;
    }

    @Override
    public boolean isIncludeInLowestCraftingDifficultyDetermination() {
        return this.includeInLowestCraftingDifficultyDetermination;
    }

    @Override
    public Object[] toObjArgs() {
        Object[] result = new Object[this.ingredients.size()];
        for (int currentIndex = 0; currentIndex < this.ingredients.size(); ++currentIndex) {
            result[currentIndex] = this.ingredients.get(currentIndex);
        }
        return result;
    }

    @Override
    public Optional<Float> getCraftingDifficulty() {
        return this.craftingDifficulty;
    }

    @Override
    public RecipeType getType() {
        return RecipeType.SHAPED;
    }

    public static class Builder {
        private final ItemStack item;
        private final List<ItemStack> ingredients = new ArrayList<ItemStack>();
        private boolean includeInLowestCraftingDifficultyDetermination = false;
        private Optional<Float> craftingDifficulty = Optional.empty();

        private Builder(ItemStack item) {
            this.item = item;
        }

        public static Builder of(ItemStack item) {
            return new Builder(item);
        }

        public Builder ingredient(Item ingredient) {
            this.ingredients.add(new ItemStack(ingredient));
            return this;
        }

        public Builder ingredient(ItemStack ingredient) {
            this.ingredients.add(ingredient);
            return this;
        }

        public Builder includeInLowestCraftingDifficultyDetermination() {
            this.includeInLowestCraftingDifficultyDetermination = true;
            return this;
        }

        public Builder difficulty(float craftingDifficulty) {
            this.craftingDifficulty = Optional.of(Float.valueOf(craftingDifficulty));
            return this;
        }

        public ShapelessRecipeModifier build() {
            return new ShapelessRecipeModifier(this.item, this.ingredients, this.includeInLowestCraftingDifficultyDetermination, this.craftingDifficulty);
        }
    }
}

