/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.reload.event.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.xiaoyu233.fml.reload.event.recipe.RecipeModifier;
import net.xiaoyu233.fml.reload.event.recipe.RecipeType;

public class ShapedRecipeModifier
implements RecipeModifier {
    private final ItemStack targetItem;
    private final List<String> pattern;
    private final Map<Character, ItemStack> ingredients;
    private final boolean include_in_lowest_crafting_difficulty_determination;
    private final Optional<Float> craftingDifficulty;

    public ShapedRecipeModifier(ItemStack targetItem, List<String> pattern, Map<Character, ItemStack> ingredients, boolean includeInLowestCraftingDifficultyDetermination, Optional<Float> craftingDifficulty) {
        this.targetItem = targetItem;
        this.pattern = pattern;
        this.ingredients = ingredients;
        this.include_in_lowest_crafting_difficulty_determination = includeInLowestCraftingDifficultyDetermination;
        this.craftingDifficulty = craftingDifficulty;
    }

    @Override
    public ItemStack getOutput() {
        return this.targetItem;
    }

    @Override
    public boolean isIncludeInLowestCraftingDifficultyDetermination() {
        return this.include_in_lowest_crafting_difficulty_determination;
    }

    @Override
    public Object[] toObjArgs() {
        Object[] result = new Object[this.pattern.size() + this.ingredients.size() * 2];
        for (int currentIndex = 0; currentIndex < this.pattern.size(); ++currentIndex) {
            result[currentIndex] = this.pattern.get(currentIndex);
        }
        for (Map.Entry<Character, ItemStack> characterItemEntry : this.ingredients.entrySet()) {
            result[currentIndex++] = characterItemEntry.getKey();
            result[currentIndex++] = characterItemEntry.getValue();
        }
        return result;
    }

    @Override
    public Optional<Float> getCraftingDifficulty() {
        return this.craftingDifficulty;
    }

    @Override
    public RecipeType getType() {
        return RecipeType.SHAPED;
    }

    public static class Builder {
        private final ItemStack item;
        private final List<String> pattern = new ArrayList<String>();
        private final Map<Character, ItemStack> ingredients = new HashMap<Character, ItemStack>();
        private boolean includeInLowestCraftingDifficultyDetermination = false;
        private Optional<Float> craftingDifficulty = Optional.empty();

        private Builder(ItemStack item) {
            this.item = item;
        }

        public static Builder of(ItemStack item) {
            return new Builder(item);
        }

        public Builder pattern(String pattern) {
            this.pattern.add(pattern);
            return this;
        }

        public Builder ingredient(char key, ItemStack ingredient) {
            this.ingredients.put(Character.valueOf(key), ingredient);
            return this;
        }

        public Builder includeInLowestCraftingDifficultyDetermination() {
            this.includeInLowestCraftingDifficultyDetermination = true;
            return this;
        }

        public Builder ingredient(char key, Item ingredient) {
            this.ingredients.put(Character.valueOf(key), new ItemStack(ingredient));
            return this;
        }

        public Builder difficulty(float craftingDifficulty) {
            this.craftingDifficulty = Optional.of(Float.valueOf(craftingDifficulty));
            return this;
        }

        public ShapedRecipeModifier build() {
            return new ShapedRecipeModifier(this.item, this.pattern, this.ingredients, this.includeInLowestCraftingDifficultyDetermination, this.craftingDifficulty);
        }
    }
}

