/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.reload.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.xiaoyu233.fml.reload.event.recipe.RecipeModifier;

public class RecipeModifyEvent {
    private final Map<ItemInfo, RecipeModifier> modifiers = new HashMap<ItemInfo, RecipeModifier>();

    public void addModifier(RecipeModifier modifier) {
        ItemStack output = modifier.getOutput();
        this.modifiers.put(new ItemInfo(output.getItem(), output.stackSize, output.getItemSubtype()), modifier);
    }

    public Map<ItemInfo, RecipeModifier> getModifiers() {
        return this.modifiers;
    }

    public static class ItemInfo {
        private final Item item;
        private final int count;
        private final int subtype;

        public ItemInfo(Item item, int count, int subtype) {
            this.item = item;
            this.count = count;
            this.subtype = subtype;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemInfo itemInfo = (ItemInfo)o;
            return this.count == itemInfo.count && this.subtype == itemInfo.subtype && Objects.equals(this.item, itemInfo.item);
        }

        public int hashCode() {
            return Objects.hash(this.item, this.count, this.subtype);
        }
    }
}

