/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.relaunch.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.fabricmc.loader.impl.discovery.ModResolutionException;
import net.fabricmc.loader.impl.util.FileSystemUtil;
import net.fabricmc.loader.impl.util.UrlUtil;
import net.xiaoyu233.fml.classloading.LaunchClassLoader;

public class JarMain {
    public static void main(String[] args) throws IOException, ModResolutionException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Object path = "";
        Path fmlPath = UrlUtil.asPath(JarMain.class.getProtectionDomain().getCodeSource().getLocation()).normalize().toAbsolutePath();
        path = (String)path + fmlPath.toString();
        Path minecraftSearchPath = Paths.get("", new String[0]).toAbsolutePath();
        Path minecraftJar = JarMain.findJarInPath(minecraftSearchPath, "net/minecraft/server/MinecraftServer.class", "MITE-HDS");
        path = (String)path + File.pathSeparator + String.valueOf(minecraftJar.normalize().toAbsolutePath());
        System.setProperty("java.class.path", (String)path);
        LaunchClassLoader modClassLoader = new LaunchClassLoader(new URL[]{fmlPath.toUri().toURL(), minecraftJar.toUri().toURL()});
        System.setProperty("minecraft.path", minecraftJar.toAbsolutePath().normalize().toString());
        modClassLoader.loadClass("net.xiaoyu233.fml.relaunch.server.Main").getMethod("main", String[].class).invoke(null, new Object[]{args});
    }

    @Nonnull
    private static Path findJarInPath(Path searchPath, String identityFilePath, String name) throws IOException {
        List<Path> availableJars;
        try (Stream<Path> list = Files.list(searchPath);){
            availableJars = list.filter(path1 -> {
                if (path1.getFileName().toString().endsWith("jar")) {
                    try {
                        FileSystemUtil.FileSystemDelegate jarFileSystem = FileSystemUtil.getJarFileSystem(path1, false);
                        return Files.exists(jarFileSystem.get().getPath(identityFilePath, new String[0]), new LinkOption[0]);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return false;
            }).toList();
        }
        if (availableJars.size() > 1) {
            throw new IllegalStateException("Found more than one available " + name + " jars, only one is required: " + String.valueOf(availableJars));
        }
        if (availableJars.isEmpty()) {
            Path path;
            block18: {
                System.err.println("Cannot find available jar " + name + " in the working dir:" + String.valueOf(searchPath));
                System.out.println("Trying to extract " + name + " from loader");
                InputStream resourceAsStream = JarMain.class.getResourceAsStream("/" + name + ".jar");
                try {
                    if (resourceAsStream == null) {
                        throw new FileNotFoundException("Cannot find " + name + " jar in the loader jar");
                    }
                    Path outPath = searchPath.resolve(name + ".jar");
                    Files.copy(resourceAsStream, outPath, new CopyOption[0]);
                    path = outPath;
                    if (resourceAsStream == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (resourceAsStream != null) {
                            try {
                                resourceAsStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IOException("Cannot extract " + name + " jar from loader", e);
                    }
                }
                resourceAsStream.close();
            }
            return path;
        }
        return availableJars.get(0);
    }
}

