/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.relaunch;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.impl.discovery.ModResolutionException;
import net.xiaoyu233.fml.classloading.KnotClassLoaderInterface;
import net.xiaoyu233.fml.classloading.LibClassifier;
import net.xiaoyu233.fml.classloading.McLibrary;
import net.xiaoyu233.fml.relaunch.Launch;
import net.xiaoyu233.fml.relaunch.LaunchClassBlocker;
import net.xiaoyu233.fml.util.LoaderUtil;
import net.xiaoyu233.fml.util.UrlUtil;

public class LaunchDelegate {
    public static void delegateLaunch(String mainClass, String[] args, boolean server) throws ClassNotFoundException, NoSuchMethodException, IOException, ModResolutionException {
        ArrayList<Path> classPath = new ArrayList<Path>();
        ArrayList<String> missing = null;
        ArrayList<String> unsupported = null;
        Path gameJarPath = LaunchDelegate.findMinecraftPath(mainClass);
        for (String cpEntry : System.getProperty("java.class.path").split(File.pathSeparator)) {
            if (cpEntry.equals("*") || cpEntry.endsWith(File.separator + "*")) {
                if (unsupported == null) {
                    unsupported = new ArrayList<String>();
                }
                unsupported.add(cpEntry);
                continue;
            }
            Path path = Paths.get(cpEntry, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                if (missing == null) {
                    missing = new ArrayList<String>();
                }
                missing.add(cpEntry);
                continue;
            }
            if (gameJarPath.equals(path.toAbsolutePath().normalize())) continue;
            classPath.add(LoaderUtil.normalizeExistingPath(path));
        }
        KnotClassLoaderInterface modClassLoader = KnotClassLoaderInterface.create();
        classPath.forEach(modClassLoader::addCodeSource);
        LaunchClassBlocker.blockClass(modClassLoader);
        modClassLoader.setValidParentClassPath(new LibClassifier<McLibrary>(McLibrary.class, server ? EnvType.SERVER : EnvType.CLIENT).getSystemLibraries());
        Launch.launch(modClassLoader, mainClass, args, server, gameJarPath);
    }

    private static Path findMinecraftPath(String mainClass) {
        String property = System.getProperty("minecraft.path");
        if (property != null) {
            return Path.of(property, new String[0]);
        }
        try {
            return UrlUtil.asPath(LaunchDelegate.class.getClassLoader().loadClass(mainClass).getProtectionDomain().getCodeSource().getLocation()).toAbsolutePath().normalize();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find minecraft path due to missing main class file in classpath, nor env var of minecraft set");
        }
    }
}

