/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.relaunch;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DevLaunchInjector {
    public static void main(String[] args) throws Throwable {
        String env = System.clearProperty("fml.dli.env");
        String main = System.clearProperty("fml.dli.main");
        String config = System.clearProperty("fml.dli.config");
        if (main == null) {
            System.err.println("error: missing fml.dli.main property, can't launch");
            System.exit(1);
        } else if (env != null && config != null) {
            Path configFile = Paths.get(DevLaunchInjector.decodeEscaped(config), new String[0]);
            if (Files.isRegularFile(configFile, new LinkOption[0]) && Files.isReadable(configFile)) {
                ArrayList<String> extraArgs = new ArrayList<String>();
                HashMap<String, String> extraProperties = new HashMap<String, String>();
                try {
                    DevLaunchInjector.parseConfig(configFile, env, extraArgs, extraProperties);
                    String[] newArgs = extraArgs.toArray(new String[args.length + extraArgs.size()]);
                    System.arraycopy(args, 0, newArgs, extraArgs.size(), args.length);
                    args = newArgs;
                    for (Map.Entry stringStringEntry : extraProperties.entrySet()) {
                        System.setProperty((String)stringStringEntry.getKey(), (String)stringStringEntry.getValue());
                    }
                }
                catch (IOException var10) {
                    DevLaunchInjector.warnNoop("parsing failed: " + String.valueOf(var10));
                }
            } else {
                DevLaunchInjector.warnNoop("missing or unreadable config file (" + String.valueOf(configFile) + ")");
            }
        } else {
            DevLaunchInjector.warnNoop("missing fml.dli.env or fml.dli.config properties");
        }
        MethodHandle handle = MethodHandles.publicLookup().findStatic(Class.forName(main), "main", MethodType.methodType(Void.TYPE, String[].class));
        handle.invokeExact(args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void parseConfig(Path file, String env, List<String> extraArgs, Map<String, String> extraProperties) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file);){
            int state = 0;
            while (true) {
                int pos;
                String line;
                block30: {
                    block31: {
                        boolean indented;
                        if ((line = reader.readLine()) == null) {
                            return;
                        }
                        if (line.isEmpty()) continue;
                        boolean bl = indented = line.charAt(0) == ' ' || line.charAt(0) == '\t';
                        if ((line = line.trim()).isEmpty()) continue;
                        if (indented) break block31;
                        if (line.startsWith("common")) {
                            pos = "common".length();
                            break block30;
                        } else if (line.startsWith(env)) {
                            pos = env.length();
                            break block30;
                        } else {
                            state = 3;
                            continue;
                        }
                    }
                    if (state == 0) {
                        throw new IOException("value without preceding attribute: " + line);
                    }
                    if (state == 1) {
                        extraArgs.add(line);
                        continue;
                    }
                    if (state == 2) {
                        pos = line.indexOf(61);
                        String key = pos >= 0 ? line.substring(0, pos).trim() : line;
                        String value = pos >= 0 ? line.substring(pos + 1).trim() : "";
                        extraProperties.put(key, value);
                        continue;
                    }
                    if (state == 3) continue;
                    throw new IllegalStateException();
                }
                state = switch (line.substring(pos)) {
                    case "Args" -> 1;
                    case "Properties" -> 2;
                    default -> throw new IOException("invalid attribute: " + line);
                };
                continue;
                break;
            }
        }
    }

    private static void warnNoop(String msg) {
        System.out.printf("warning: dev-launch-injector in pass-through mode, %s%n", msg);
    }

    private static String decodeEscaped(String s) {
        if (!s.contains("@@")) {
            return s;
        }
        Matcher matcher = Pattern.compile("@@([0-9a-fA-F]{1,4})").matcher(s);
        StringBuilder ret = new StringBuilder(s.length());
        int start = 0;
        while (matcher.find()) {
            ret.append(s, start, matcher.start());
            ret.append((char)Integer.parseInt(matcher.group(1), 16));
            start = matcher.end();
        }
        ret.append(s, start, s.length());
        return ret.toString();
    }
}

