/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.mixin.service;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.logging.LoggerAdapterAbstract;

final class MixinLogger
extends LoggerAdapterAbstract {
    private static final Logger LOGGER = LogManager.getLogger("Mixin");
    private static final Map<String, ILogger> LOGGER_MAP = new ConcurrentHashMap<String, ILogger>();
    private static final Map<org.spongepowered.asm.logging.Level, Level> LEVEL_MAP = MixinLogger.createLevelMap();

    MixinLogger(String name) {
        super(name);
    }

    static ILogger get(String name) {
        return LOGGER_MAP.computeIfAbsent(name, MixinLogger::new);
    }

    private static Level translateLevel(org.spongepowered.asm.logging.Level level) {
        return LEVEL_MAP.getOrDefault((Object)level, Level.INFO);
    }

    private static Map<org.spongepowered.asm.logging.Level, Level> createLevelMap() {
        EnumMap<org.spongepowered.asm.logging.Level, Level> ret = new EnumMap<org.spongepowered.asm.logging.Level, Level>(org.spongepowered.asm.logging.Level.class);
        ret.put(org.spongepowered.asm.logging.Level.FATAL, Level.ERROR);
        ret.put(org.spongepowered.asm.logging.Level.ERROR, Level.ERROR);
        ret.put(org.spongepowered.asm.logging.Level.WARN, Level.WARN);
        ret.put(org.spongepowered.asm.logging.Level.INFO, Level.INFO);
        ret.put(org.spongepowered.asm.logging.Level.DEBUG, Level.DEBUG);
        ret.put(org.spongepowered.asm.logging.Level.TRACE, Level.TRACE);
        return ret;
    }

    @Override
    public String getType() {
        return "Fabric Mixin Logger";
    }

    @Override
    public void catching(org.spongepowered.asm.logging.Level level, Throwable t) {
        this.log(level, "Catching ".concat(t.toString()), t);
    }

    @Override
    public void log(org.spongepowered.asm.logging.Level level, String message, Object ... params) {
        Level fabricLevel = MixinLogger.translateLevel(level);
        Throwable exc = null;
        if (params != null && params.length > 0) {
            if (message == null) {
                if (params[0] instanceof Throwable) {
                    exc = (Throwable)params[0];
                }
            } else {
                StringBuilder sb = new StringBuilder(message.length() + 20);
                int paramIdx = 0;
                boolean escaped = false;
                int max = message.length();
                for (int i = 0; i < max; ++i) {
                    char c = message.charAt(i);
                    if (escaped) {
                        sb.append(c);
                        escaped = false;
                        continue;
                    }
                    if (c == '\\' && i + 1 < max) {
                        escaped = true;
                        continue;
                    }
                    if (c == '{' && i + 1 < max && message.charAt(i + 1) == '}' && paramIdx < params.length) {
                        Object param;
                        if ((param = params[paramIdx++]) == null) {
                            sb.append("null");
                        } else if (param.getClass().isArray()) {
                            String val = Arrays.deepToString(new Object[]{param});
                            sb.append(val, 1, val.length() - 1);
                        } else {
                            sb.append(param);
                        }
                        ++i;
                        continue;
                    }
                    sb.append(c);
                }
                message = sb.toString();
                if (paramIdx < params.length && params[params.length - 1] instanceof Throwable) {
                    exc = (Throwable)params[params.length - 1];
                }
            }
        }
        LOGGER.log(fabricLevel, message, exc);
    }

    @Override
    public void log(org.spongepowered.asm.logging.Level level, String message, Throwable t) {
        LOGGER.log(MixinLogger.translateLevel(level), message, t);
    }

    @Override
    public <T extends Throwable> T throwing(T t) {
        this.log(org.spongepowered.asm.logging.Level.ERROR, "Throwing ".concat(t.toString()), t);
        return t;
    }
}

