/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.mapping;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.tinyremapper.IMappingProvider;
import net.fabricmc.tinyremapper.NonClassCopyMode;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CachedMappedJar {
    private static final Logger LOGGER = LogManager.getLogger("GameRemapper");
    private final Path jarSource;
    private final Path cacheDir;
    private final TinyRemapper remapper;

    public CachedMappedJar(Path jarSource, IMappingProvider provider, File minecraftDir) throws IOException {
        this.jarSource = jarSource;
        TinyRemapper.Builder builder = TinyRemapper.newRemapper().withMappings(provider).ignoreConflicts(true).checkPackageAccess(true);
        this.remapper = builder.build();
        this.cacheDir = minecraftDir.toPath().resolve(".fml").resolve("remappedJars");
        Files.createDirectories(this.cacheDir, new FileAttribute[0]);
    }

    public Path ensureJarMapped() {
        Path mappedJar = this.cacheDir.resolve(String.valueOf(this.jarSource.getFileName()) + "-3.4.2.jar");
        boolean injectionsInvalid = false;
        if (Files.exists(mappedJar, new LinkOption[0]) && !injectionsInvalid) {
            LOGGER.info("Found mapped jar cache");
            return mappedJar;
        }
        LOGGER.info("Mapped jar cache not found, remapping with TinyRemapper on FML version 3.4.2");
        try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(mappedJar).build();){
            outputConsumer.addNonClassFiles(this.jarSource, NonClassCopyMode.UNCHANGED, this.remapper);
            this.remapper.readInputs(this.jarSource);
            this.remapper.apply(outputConsumer);
            LOGGER.info("Minecraft jar has successfully remapped");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.remapper.finish();
        }
        return mappedJar;
    }
}

