/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.config.editor;

import com.google.gson.JsonElement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.xiaoyu233.fml.config.Codec;
import net.xiaoyu233.fml.config.Config;
import net.xiaoyu233.fml.config.ConfigCategory;
import net.xiaoyu233.fml.config.ConfigEntry;
import net.xiaoyu233.fml.config.ConfigRegistry;

public class ConfigEditor
extends JFrame {
    private static final Font TREE_FONT = new Font("Default", 0, 16);
    private final List<Runnable> saveRuns = new ArrayList<Runnable>();
    private final int width = 600;
    private final int height = 550;

    public ConfigEditor(List<ConfigRegistry> registries) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("\u6240\u6709\u914d\u7f6e");
        for (ConfigRegistry registry : registries) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("\u914d\u7f6e\u6587\u4ef6 " + registry.getPathToConfigFile().getName());
            root.add(defaultMutableTreeNode);
            this.addAllConfigs(registry.getRoot(), defaultMutableTreeNode);
        }
        DefaultTreeModel model = new DefaultTreeModel(root);
        final JTree tree = new JTree(model);
        tree.setFont(TREE_FONT);
        tree.setExpandsSelectedPaths(true);
        tree.setRowHeight(TREE_FONT.getSize() + 5);
        tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (!leaf) {
                    return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                }
                EditingUnit editingUnit = ((ConfigTreeNode)value).editingUnit;
                editingUnit.setBackground(hasFocus ? this.getBackgroundSelectionColor() : this.getBackgroundNonSelectionColor());
                return editingUnit;
            }
        });
        tree.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Runnable saveChange;
                super.focusLost(e);
                Object lastSelectedPathComponent = tree.getLastSelectedPathComponent();
                if (lastSelectedPathComponent instanceof ConfigTreeNode && !ConfigEditor.this.saveRuns.contains(saveChange = ((ConfigTreeNode)lastSelectedPathComponent).editingUnit.saveChange)) {
                    ConfigEditor.this.saveRuns.add(saveChange);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(tree);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "North");
        this.setDefaultCloseOperation(2);
        Box optBox = Box.createHorizontalBox();
        JButton cancel = new JButton("\u53d6\u6d88");
        cancel.addActionListener(e -> this.dispose());
        optBox.add(cancel);
        optBox.add(Box.createVerticalGlue());
        JButton reset = new JButton("\u91cd\u7f6e\u5f53\u524d\u9009\u9879");
        reset.addActionListener(e -> {
            Object lastSelectedPathComponent = tree.getLastSelectedPathComponent();
            if (lastSelectedPathComponent instanceof ConfigTreeNode) {
                ConfigTreeNode node = (ConfigTreeNode)lastSelectedPathComponent;
                node.editingUnit.reloadValue.accept(node.getConfigEntry().getDefaultValue());
                node.editingUnit.repaint();
                tree.repaint();
            }
        });
        optBox.add(reset);
        optBox.add(Box.createHorizontalGlue());
        JButton save = new JButton("\u4fdd\u5b58\u5e76\u9000\u51fa");
        save.addActionListener(e -> {
            for (Runnable saveRun : this.saveRuns) {
                saveRun.run();
            }
            for (ConfigRegistry registry : registries) {
                try (FileWriter writer = new FileWriter(registry.getPathToConfigFile());){
                    Config.GSON.toJson((JsonElement)registry.getRoot().write(), (Appendable)writer);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                registry.reloadConfig();
            }
            JOptionPane.showMessageDialog(this, "\u4fdd\u5b58\u6210\u529f,\u66f4\u6539\u5df2\u751f\u6548!");
            this.dispose();
        });
        optBox.add(save);
        this.add((Component)optBox, "South");
        tree.setEditable(true);
        tree.setCellEditor(new DefaultCellEditor(new JTextField()){

            @Override
            public void cancelCellEditing() {
                super.cancelCellEditing();
                Runnable saveChange = ((ConfigTreeNode)tree.getLastSelectedPathComponent()).editingUnit.saveChange;
                if (!ConfigEditor.this.saveRuns.contains(saveChange)) {
                    ConfigEditor.this.saveRuns.add(saveChange);
                }
            }

            @Override
            public Component getTreeCellEditorComponent(JTree tree2, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
                if (!leaf) {
                    if (!expanded) {
                        tree2.expandPath(tree2.getSelectionPath());
                    } else {
                        tree2.collapsePath(tree2.getSelectionPath());
                    }
                }
                return tree2.getCellRenderer().getTreeCellRendererComponent(tree2, value, isSelected, expanded, leaf, row, true);
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                TreePath path;
                if (anEvent instanceof MouseEvent && (path = tree.getPathForLocation(((MouseEvent)anEvent).getX(), ((MouseEvent)anEvent).getY())) != null) {
                    Object value = path.getLastPathComponent();
                    TreeModel treeModel = tree.getModel();
                    boolean leaf = treeModel.isLeaf(value);
                    if (!leaf) {
                        if (((MouseEvent)anEvent).getClickCount() >= 1) {
                            if (tree.isExpanded(path)) {
                                tree.collapsePath(path);
                            } else {
                                tree.expandPath(path);
                            }
                        }
                        return false;
                    }
                    return true;
                }
                return true;
            }

            @Override
            public boolean stopCellEditing() {
                Runnable saveChange = ((ConfigTreeNode)tree.getLastSelectedPathComponent()).editingUnit.saveChange;
                if (!ConfigEditor.this.saveRuns.contains(saveChange)) {
                    ConfigEditor.this.saveRuns.add(saveChange);
                }
                return super.stopCellEditing();
            }
        });
        DisplayMode displayMode = this.getGraphicsConfiguration().getDevice().getDisplayMode();
        this.setBounds((displayMode.getWidth() - this.width) / 2, (displayMode.getHeight() - this.height) / 2, this.width, this.height);
    }

    private void addAllConfigs(Config config, DefaultMutableTreeNode root) {
        if (config instanceof ConfigCategory) {
            String comment = ((ConfigCategory)config).getComment();
            if (comment == null || comment.isEmpty()) {
                comment = config.getName();
            }
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(comment);
            root.add(defaultMutableTreeNode);
            for (Config child : ((ConfigCategory)config).getChild()) {
                this.addAllConfigs(child, defaultMutableTreeNode);
            }
        } else if (config instanceof ConfigEntry) {
            root.add(new ConfigTreeNode((ConfigEntry)config));
        }
    }

    static class ConfigTreeNode
    extends DefaultMutableTreeNode {
        private final ConfigEntry<?> configEntry;
        private final EditingUnit editingUnit;

        ConfigTreeNode(ConfigEntry<?> configEntry) {
            this.configEntry = configEntry;
            this.editingUnit = new EditingUnit(this);
        }

        public ConfigEntry<?> getConfigEntry() {
            return this.configEntry;
        }

        @Override
        public String toString() {
            return this.configEntry.getComment();
        }
    }

    static class EditingUnit
    extends Box {
        private Consumer<Object> reloadValue = t -> {};
        private Runnable saveChange = () -> {};

        private EditingUnit(ConfigTreeNode value) {
            super(0);
            ConfigEntry<?> configEntry = value.getConfigEntry();
            JLabel comp1 = new JLabel(configEntry.getComment());
            comp1.setFont(TREE_FONT);
            this.add(comp1);
            this.add(Box.createHorizontalGlue());
            JComponent comp = this.getSuitableEditComponent(configEntry);
            comp.setFont(TREE_FONT);
            this.add(comp);
        }

        private JComponent getSuitableEditComponent(ConfigEntry<?> configEntry) {
            Codec<?> codec = configEntry.getCodec();
            if (codec == Codec.BOOLEAN) {
                ConfigEntry<?> newEntry = configEntry;
                JCheckBox jCheckBox = new JCheckBox();
                jCheckBox.setBorderPaintedFlat(true);
                jCheckBox.setSelected((Boolean)configEntry.getCurrentValue());
                jCheckBox.setPreferredSize(new Dimension(20, jCheckBox.getHeight()));
                jCheckBox.setBackground(new Color(253, 253, 254, 255));
                this.saveChange = () -> {
                    newEntry.setCurrentValue(jCheckBox.isSelected());
                    System.out.println("Save change for " + configEntry.getComment());
                };
                this.reloadValue = value -> jCheckBox.setSelected((Boolean)value);
                return jCheckBox;
            }
            if (codec == Codec.DOUBLE || codec == Codec.FLOAT) {
                JFormattedTextField jFormattedTextField = new JFormattedTextField(configEntry.getCurrentValue());
                DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory();
                NumberFormat numberInstance = DecimalFormat.getNumberInstance();
                numberInstance.setGroupingUsed(false);
                NumberFormatter atf = new NumberFormatter(numberInstance);
                atf.setAllowsInvalid(false);
                atf.setCommitsOnValidEdit(true);
                defaultFormatterFactory.setDefaultFormatter(atf);
                jFormattedTextField.setFormatterFactory(defaultFormatterFactory);
                Dimension preferredSize = jFormattedTextField.getPreferredSize();
                preferredSize.setSize(preferredSize.getWidth() + 40.0, preferredSize.getHeight());
                jFormattedTextField.setPreferredSize(preferredSize);
                this.saveChange = codec == Codec.DOUBLE ? () -> {
                    configEntry.setCurrentValue(((Number)jFormattedTextField.getValue()).doubleValue());
                    System.out.println("Save change for " + configEntry.getComment());
                } : () -> {
                    configEntry.setCurrentValue(Float.valueOf(((Number)jFormattedTextField.getValue()).floatValue()));
                    System.out.println("Save change for " + configEntry.getComment());
                };
                this.reloadValue = jFormattedTextField::setValue;
                return jFormattedTextField;
            }
            if (codec == Codec.INTEGER) {
                JFormattedTextField jFormattedTextField = new JFormattedTextField(configEntry.getCurrentValue());
                DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory();
                NumberFormat integerInstance = DecimalFormat.getIntegerInstance();
                integerInstance.setGroupingUsed(false);
                NumberFormatter atf = new NumberFormatter(integerInstance);
                atf.setAllowsInvalid(false);
                atf.setCommitsOnValidEdit(true);
                defaultFormatterFactory.setDefaultFormatter(atf);
                jFormattedTextField.setFormatterFactory(defaultFormatterFactory);
                Dimension preferredSize = jFormattedTextField.getPreferredSize();
                preferredSize.setSize(preferredSize.getWidth() + 40.0, preferredSize.getHeight());
                jFormattedTextField.setPreferredSize(preferredSize);
                this.saveChange = () -> {
                    configEntry.setCurrentValue(((Number)jFormattedTextField.getValue()).intValue());
                    System.out.println("Save change for " + configEntry.getComment());
                };
                this.reloadValue = jFormattedTextField::setValue;
                return jFormattedTextField;
            }
            if (codec == Codec.STRING || codec == Codec.FILE) {
                JTextField jTextField = new JTextField(configEntry.getCurrentValue().toString());
                Dimension preferredSize = jTextField.getPreferredSize();
                preferredSize.setSize(preferredSize.getWidth() + 40.0, preferredSize.getHeight());
                jTextField.setPreferredSize(preferredSize);
                this.saveChange = codec == Codec.STRING ? () -> {
                    configEntry.setCurrentValue(jTextField.getText());
                    System.out.println("Save change for " + configEntry.getComment());
                } : () -> {
                    configEntry.setCurrentValue(new File(jTextField.getText()));
                    System.out.println("Save change for " + configEntry.getComment());
                };
                this.reloadValue = value -> jTextField.setText(value.toString());
                return jTextField;
            }
            throw new IllegalArgumentException("Unsupported codec: " + String.valueOf(codec));
        }

        @Override
        public void paint(Graphics g) {
            if (this.getBackground() != null) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            super.paint(g);
        }
    }
}

