/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.config;

import com.google.gson.JsonElement;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.xiaoyu233.fml.FishModLoader;
import net.xiaoyu233.fml.config.Codec;
import net.xiaoyu233.fml.config.Config;
import net.xiaoyu233.fml.config.ConfigEntry;
import net.xiaoyu233.fml.util.FieldReference;
import org.apache.commons.lang3.Range;

public class RangedConfigEntry<T extends Comparable<T>>
extends ConfigEntry<T> {
    private final Range<T> valueRange;

    RangedConfigEntry(String name, Codec<T> codec, T defaultValue, FieldReference<T> configRef, Range<T> valueRange) {
        super(name, codec, defaultValue, configRef);
        this.valueRange = valueRange;
        if (!valueRange.contains(defaultValue)) {
            throw new IllegalArgumentException("Default value " + String.valueOf(defaultValue) + "is out of range " + String.valueOf(valueRange) + " for config entry " + name);
        }
    }

    RangedConfigEntry(String name, FieldReference<T> configRef, Range<T> valueRange) {
        this(name, Codec.getFromClass(configRef.getValueClass()), (Comparable)configRef.get(), configRef, valueRange);
    }

    RangedConfigEntry(String name, Codec<T> codec, FieldReference<T> configRef, Range<T> valueRange) {
        this(name, codec, (Comparable)configRef.get(), configRef, valueRange);
    }

    @Override
    public void setCurrentValue(T value) {
        super.setCurrentValue(this.fit(value));
    }

    @Override
    @Nonnull
    public Config.ReadResult read(JsonElement json) {
        try {
            if (json != null) {
                if (json.isJsonObject()) {
                    Comparable read = (Comparable)this.codec.read(json.getAsJsonObject().get("value"));
                    Comparable clamped = this.fit(read);
                    this.configRef.set(clamped);
                    if (!json.getAsJsonObject().get("_comment").getAsString().equals(this.comment) || read != clamped) {
                        return Config.ReadResult.ofChanged(this.writeWithValue((Comparable)this.configRef.get()));
                    }
                } else {
                    Comparable read = (Comparable)this.codec.read(json);
                    Comparable clamped = this.fit(read);
                    this.configRef.set(clamped);
                    if (this.comment != null && !this.comment.isEmpty() || read != clamped) {
                        return Config.ReadResult.ofChanged(this.writeWithValue((Comparable)this.configRef.get()));
                    }
                }
                return Config.ReadResult.NO_CHANGE;
            }
            this.configRef.set((Comparable)this.defaultValue);
            return Config.ReadResult.ofChanged(this.writeDefault());
        }
        catch (Throwable t) {
            FishModLoader.LOGGER.error("Cannot read config: " + this.getName(), t);
            this.configRef.set((Comparable)this.defaultValue);
            return Config.ReadResult.ofChanged(this.writeDefault());
        }
    }

    @Override
    public ConfigEntry<T> withComment(String comment) {
        return super.withComment(comment + "\u2208" + this.valueRange.toString());
    }

    private T fit(T element) {
        Objects.requireNonNull(element, "element");
        if (this.valueRange.isAfter(element)) {
            return (T)((Comparable)this.valueRange.getMinimum());
        }
        return (T)(this.valueRange.isBefore(element) ? (Comparable)this.valueRange.getMaximum() : element);
    }
}

