/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.config;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import javax.annotation.Nonnull;
import net.xiaoyu233.fml.FishModLoader;
import net.xiaoyu233.fml.util.PackageLoader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.Config;
import org.spongepowered.asm.mixin.transformer.MixinConfig;
import org.spongepowered.asm.service.IMixinService;

public class InjectionConfig {
    private static final Gson gson = new Gson();
    private final MixinEnvironment.CompatibilityLevel compatibleLevel;
    private final int defaultRequiredInjection;
    private final int mixinPriority;
    private final String minMixinVersion;
    private final String name;
    private final boolean required;
    @Nonnull
    private final String pluginClassName;
    private final MixinEnvironment.Phase targetPhase;
    private final Package transformPackage;

    public InjectionConfig(Package transformPackage, MixinEnvironment.CompatibilityLevel compatibleLevel, int mixinPriority, MixinEnvironment.Phase targetPhase, String minMixinVersion, int defaultRequiredInjection, boolean required, String name, @Nonnull String pluginClassName) {
        this.transformPackage = transformPackage;
        this.compatibleLevel = compatibleLevel;
        this.mixinPriority = mixinPriority;
        this.targetPhase = targetPhase;
        this.minMixinVersion = minMixinVersion;
        this.defaultRequiredInjection = defaultRequiredInjection;
        this.required = required;
        this.name = name;
        this.pluginClassName = pluginClassName;
    }

    public MixinEnvironment.CompatibilityLevel getCompatibleLevel() {
        return this.compatibleLevel;
    }

    public int getDefaultRequiredInjection() {
        return this.defaultRequiredInjection;
    }

    public String getMinMixinVersion() {
        return this.minMixinVersion;
    }

    public MixinEnvironment.Phase getTargetPhase() {
        return this.targetPhase;
    }

    public Package getTransformPackage() {
        return this.transformPackage;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Config toConfig(ClassLoader classLoader, IMixinService mixinService, MixinEnvironment environment) {
        MixinConfig config = this.toMixinConfig(classLoader);
        config.onLoad(mixinService, this.name, environment);
        return new Config(config);
    }

    private MixinConfig toMixinConfig(ClassLoader classLoader) {
        JsonObject mixinObject = new JsonObject();
        mixinObject.addProperty("required", Boolean.valueOf(this.required));
        String pkgName = this.transformPackage.getName();
        mixinObject.addProperty("package", pkgName);
        mixinObject.addProperty("compatibilityLevel", this.compatibleLevel.toString());
        JsonArray mixins = new JsonArray();
        List<String> classes = PackageLoader.getClasses(pkgName, classLoader, Mixin.class);
        for (String aClass : classes) {
            String clName = aClass.replace(pkgName + ".", "");
            FishModLoader.LOGGER.info("Registering mixin class:" + clName + " for " + this.name);
            mixins.add((JsonElement)new JsonPrimitive(clName));
        }
        mixinObject.addProperty("mixinPriority", (Number)this.mixinPriority);
        mixinObject.add("mixins", (JsonElement)mixins);
        if (!this.pluginClassName.isEmpty()) {
            mixinObject.addProperty("plugin", this.pluginClassName);
        }
        JsonObject injectors = new JsonObject();
        injectors.addProperty("defaultRequire", (Number)this.defaultRequiredInjection);
        mixinObject.add("injectors", (JsonElement)injectors);
        mixinObject.addProperty("minVersion", this.minMixinVersion);
        mixinObject.addProperty("target", "@env(" + this.targetPhase.toString() + ")");
        return (MixinConfig)gson.fromJson((JsonElement)mixinObject, MixinConfig.class);
    }

    public static class Builder {
        private final String name;
        private final MixinEnvironment.Phase targetPhase;
        private final Package transformPackage;
        private MixinEnvironment.CompatibilityLevel compatibleLevel = MixinEnvironment.CompatibilityLevel.JAVA_17;
        private int defaultRequiredInjection = 0;
        private String minMixinVersion = MixinEnvironment.getDefaultEnvironment().getVersion();
        private boolean required = false;
        private int mixinPriority = 1000;
        private String pluginClassName = "";

        private Builder(String name, Package transformPackage, MixinEnvironment.Phase targetPhase) {
            this.name = name;
            this.transformPackage = transformPackage;
            this.targetPhase = targetPhase;
        }

        public static Builder of(String name, Package transformPackage, MixinEnvironment.Phase targetPhase) {
            return new Builder(name, transformPackage, targetPhase);
        }

        public InjectionConfig build() {
            return new InjectionConfig(this.transformPackage, this.compatibleLevel, this.mixinPriority, this.targetPhase, this.minMixinVersion, this.defaultRequiredInjection, this.required, this.name, this.pluginClassName);
        }

        public Builder setCompatibleLevel(MixinEnvironment.CompatibilityLevel compatibleLevel) {
            this.compatibleLevel = compatibleLevel;
            return this;
        }

        public Builder setDefaultRequiredInjection(int defaultRequiredInjection) {
            this.defaultRequiredInjection = defaultRequiredInjection;
            return this;
        }

        public Builder setMinMixinVersion(String minMixinVersion) {
            this.minMixinVersion = minMixinVersion;
            return this;
        }

        public Builder setMixinPriority(int priority) {
            this.mixinPriority = priority;
            return this;
        }

        public Builder plugin(String pluginClassName) {
            this.pluginClassName = pluginClassName;
            return this;
        }

        public Builder setRequired() {
            this.required = true;
            return this;
        }
    }
}

