/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.config;

import com.google.common.base.Charsets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.xiaoyu233.fml.FishModLoader;
import net.xiaoyu233.fml.config.Config;
import net.xiaoyu233.fml.config.ConfigCategory;

public class ConfigRoot
extends ConfigCategory {
    private static final String CONFIG_VERSION_NAME = "config_version";
    private final int configVersion;

    public ConfigRoot(int configVersion) {
        super("root");
        this.configVersion = configVersion;
    }

    public static ConfigRoot create(int configVersion) {
        return new ConfigRoot(configVersion);
    }

    @Override
    public ConfigRoot addEntry(Config entry) {
        super.addEntry(entry);
        return this;
    }

    @Override
    public ConfigRoot withComment(String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public JsonObject writeDefault() {
        JsonObject object = super.writeDefault();
        object.addProperty(CONFIG_VERSION_NAME, (Number)this.configVersion);
        return object;
    }

    public void readFromFile(File cfgFile) {
        block25: {
            OutputStreamWriter writer;
            File configFile;
            Config.ReadResult read;
            block23: {
                read = Config.ReadResult.NO_CHANGE;
                configFile = new File(FishModLoader.CONFIG_DIR, cfgFile.toString());
                if (!configFile.exists()) {
                    try {
                        configFile.getParentFile().mkdirs();
                        if (!configFile.createNewFile()) {
                            FishModLoader.LOGGER.error("Cannot create config file");
                            break block23;
                        }
                        writer = new OutputStreamWriter(Files.newOutputStream(configFile.toPath(), new OpenOption[0]), Charsets.UTF_8);
                        try {
                            JsonObject jsonElement = this.writeDefault();
                            jsonElement.addProperty(CONFIG_VERSION_NAME, (Number)this.configVersion);
                            GSON.toJson((JsonElement)jsonElement, (Appendable)writer);
                        }
                        finally {
                            writer.close();
                        }
                    }
                    catch (IOException e) {
                        FishModLoader.LOGGER.error("Cannot create config file", (Throwable)e);
                    }
                }
            }
            try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(configFile.toPath(), new OpenOption[0]), Charsets.UTF_8);){
                read = this.read(new JsonParser().parse((Reader)reader));
            }
            catch (Throwable e) {
                FishModLoader.LOGGER.error("Error in reading config", e);
            }
            try {
                if (!read.isDirty()) break block25;
                writer = new FileWriter(configFile);
                try {
                    GSON.toJson(read.getChanged(), (Appendable)writer);
                }
                finally {
                    writer.close();
                }
            }
            catch (Throwable e) {
                FishModLoader.LOGGER.error("Error in writing config", e);
            }
        }
    }

    @Override
    @Nonnull
    public Config.ReadResult read(JsonElement json) {
        if (json.isJsonObject()) {
            JsonObject originalObj = json.getAsJsonObject();
            if (originalObj.has(CONFIG_VERSION_NAME)) {
                int inFileVersion = originalObj.get(CONFIG_VERSION_NAME).getAsInt();
                if (inFileVersion < this.configVersion) {
                    return Config.ReadResult.ofChanged((JsonElement)this.writeDefault());
                }
            } else {
                JsonObject resultObj = originalObj;
                Config.ReadResult read = super.read(json);
                if (read.isDirty()) {
                    resultObj = Objects.requireNonNull(read.getChanged()).getAsJsonObject();
                }
                resultObj.addProperty(CONFIG_VERSION_NAME, (Number)this.configVersion);
                return Config.ReadResult.ofChanged((JsonElement)resultObj);
            }
        }
        return super.read(json);
    }
}

