/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.config;

import com.google.common.base.Objects;
import java.io.File;
import net.xiaoyu233.fml.FishModLoader;
import net.xiaoyu233.fml.config.ConfigRoot;

public class ConfigRegistry {
    private final File pathToConfigFile;
    private final File configFile;
    private final ConfigRoot root;
    private Runnable reloadRun = () -> {};

    public ConfigRegistry(ConfigRoot root, File pathToConfigFile) {
        this.root = root;
        this.configFile = pathToConfigFile;
        this.pathToConfigFile = new File(FishModLoader.CONFIG_DIR, pathToConfigFile.toString());
    }

    public ConfigRegistry setReloadRun(Runnable reloadRun) {
        this.reloadRun = reloadRun;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigRegistry that = (ConfigRegistry)o;
        return Objects.equal(this.root, that.root);
    }

    public File getPathToConfigFile() {
        return this.pathToConfigFile;
    }

    public ConfigRoot getRoot() {
        return this.root;
    }

    public int hashCode() {
        return Objects.hashCode(this.root);
    }

    public void reloadConfig() {
        this.root.readFromFile(this.configFile);
        this.reloadRun.run();
    }
}

