/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.classloading.dump;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.xiaoyu233.fml.FishModLoader;
import net.xiaoyu233.fml.classloading.dump.DumpStage;
import net.xiaoyu233.fml.config.Configs;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class ClassDumper {
    public static void dumpClassStaged(ClassNode classNode, String className, DumpStage stage) {
        ClassWriter writer = new ClassWriter(0);
        classNode.accept(writer);
        ClassDumper.dumpClassStaged(writer.toByteArray(), className, stage);
    }

    public static void dumpClassStaged(byte[] classNode, String className, DumpStage stage) {
        if (!Configs.Debug.DEBUG.get().booleanValue()) {
            return;
        }
        if (!stage.shouldDump()) {
            return;
        }
        if (!className.startsWith(Configs.Debug.DumpClass.DUMP_PREFIX.get())) {
            return;
        }
        className = className.replace(".", "/");
        Path dumpPath = Configs.Debug.DumpClass.DUMP_PATH.get().toPath().resolve(stage.name().toLowerCase()).resolve(className + ".class");
        try {
            ClassDumper.ensureDumpDir(dumpPath.getParent());
            Files.write(dumpPath, classNode, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            FishModLoader.LOGGER.error("Cannot dump class {} to {}", (Object)className, (Object)dumpPath, (Object)e);
        }
    }

    private static void ensureDumpDir(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.createDirectories(path, new FileAttribute[0]);
    }
}

