/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.classloading;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.xiaoyu233.fml.asm.IClassNameTransformer;
import net.xiaoyu233.fml.asm.IClassTransformer;
import net.xiaoyu233.fml.classloading.KnotClassDelegate;
import net.xiaoyu233.fml.config.Configs;
import net.xiaoyu233.fml.util.FileSystemUtil;
import net.xiaoyu233.fml.util.LoaderUtil;
import net.xiaoyu233.fml.util.LogWrapper;
import net.xiaoyu233.fml.util.ManifestUtil;
import net.xiaoyu233.fml.util.UrlConversionException;
import net.xiaoyu233.fml.util.UrlUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public class LaunchClassLoader
extends URLClassLoader {
    public static final int BUFFER_SIZE = 4096;
    private final List<URL> sources;
    private final ClassLoader parent = this.getClass().getClassLoader();
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("legacy.debugClassLoading", "false")) || Configs.Debug.DEBUG.get() != false;
    private final Map<String, Class<?>> cachedClasses = new ConcurrentHashMap();
    private final Set<String> classLoaderExceptions = new HashSet<String>();
    private final Set<String> invalidClasses = new HashSet<String>(1000);
    private final ThreadLocal<byte[]> loadBuffer = new ThreadLocal();
    private final Set<String> negativeResourceCache = Collections.newSetFromMap(new ConcurrentHashMap());
    private IClassNameTransformer renameTransformer;
    private final Map<String, byte[]> resourceCache = new ConcurrentHashMap<String, byte[]>(1000);
    private static final String[] RESERVED_NAMES;
    private final Set<String> transformerExceptions = new HashSet<String>();
    private static final boolean DEBUG_FINER;
    private static final boolean DEBUG_SAVE;
    private static File tempFolder;
    private final List<IClassTransformer> transformers = new ArrayList<IClassTransformer>(2);
    private final Map<Path, KnotClassDelegate.Metadata> metadataCache = new ConcurrentHashMap<Path, KnotClassDelegate.Metadata>();

    public void registerTransformer(IClassTransformer transformer) {
        try {
            this.transformers.add(transformer);
            if (this.renameTransformer == null && transformer instanceof IClassNameTransformer) {
                this.renameTransformer = (IClassNameTransformer)transformer;
            }
        }
        catch (Exception var3) {
            LogWrapper.log(Level.ERROR, var3, "A critical problem occurred registering the ASM transformer class %s", transformer);
        }
    }

    public void registerTransformer(String transformerClassName) {
        try {
            IClassTransformer transformer = (IClassTransformer)this.parent.loadClass(transformerClassName).newInstance();
            this.transformers.add(transformer);
            if (this.renameTransformer == null && transformer instanceof IClassNameTransformer) {
                this.renameTransformer = (IClassNameTransformer)transformer;
            }
        }
        catch (Exception var3) {
            LogWrapper.log(Level.ERROR, var3, "A critical problem occurred registering the ASM transformer class %s", transformerClassName);
        }
    }

    public LaunchClassLoader(URL[] sources) {
        super(sources, (ClassLoader)null);
        this.sources = new ArrayList<URL>(Arrays.asList(sources));
        this.addClassLoaderExclusion("java.");
        this.addClassLoaderExclusion("sun.");
        this.addClassLoaderExclusion("javax.");
        if (DEBUG_SAVE) {
            tempFolder = Configs.Debug.DumpClass.DUMP_PATH.get();
            LogWrapper.info("DEBUG_SAVE Enabled, saving all classes to \"%s\"", tempFolder.getAbsolutePath().replace('\\', '/'));
            tempFolder.mkdirs();
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.invalidClasses.contains(name)) {
            throw new ClassNotFoundException(name);
        }
        for (String exception : this.classLoaderExceptions) {
            if (!name.startsWith(exception)) continue;
            return this.parent.loadClass(name);
        }
        if (this.cachedClasses.containsKey(name)) {
            return this.cachedClasses.get(name);
        }
        for (String exception : this.transformerExceptions) {
            if (!name.startsWith(exception)) continue;
            try {
                Class<?> clazz = super.findClass(name);
                this.cachedClasses.put(name, clazz);
                return clazz;
            }
            catch (ClassNotFoundException e) {
                this.invalidClasses.add(name);
                throw e;
            }
        }
        try {
            String transformedName = this.transformName(name.replace(".", "/")).replace("/", ".");
            if (this.cachedClasses.containsKey(transformedName)) {
                return this.cachedClasses.get(transformedName);
            }
            String untransformedName = this.untransformName(name.replace(".", "/"));
            int lastDot = untransformedName.lastIndexOf(46);
            String packageName = lastDot == -1 ? "" : untransformedName.substring(0, lastDot);
            String fileName = untransformedName.replace('.', '/').concat(".class");
            URLConnection urlConnection = this.findCodeSourceConnectionFor(fileName);
            CodeSigner[] signers = null;
            if (lastDot > -1 && !untransformedName.startsWith("net.minecraft.")) {
                if (urlConnection instanceof JarURLConnection) {
                    JarURLConnection jarURLConnection = (JarURLConnection)urlConnection;
                    JarFile jarFile = jarURLConnection.getJarFile();
                    if (jarFile != null && jarFile.getManifest() != null) {
                        Manifest manifest = jarFile.getManifest();
                        JarEntry entry = jarFile.getJarEntry(fileName);
                        Package pkg = this.getPackage(packageName);
                        this.getClassBytes(untransformedName);
                        signers = entry.getCodeSigners();
                        if (pkg == null) {
                            pkg = this.definePackage(packageName, manifest, jarURLConnection.getJarFileURL());
                        } else if (pkg.isSealed() && !pkg.isSealed(jarURLConnection.getJarFileURL())) {
                            LogWrapper.severe("The jar file %s is trying to seal already secured path %s", jarFile.getName(), packageName);
                        } else if (this.isSealed(packageName, manifest)) {
                            LogWrapper.severe("The jar file %s has a security seal for path %s, but that path is defined and not secure", jarFile.getName(), packageName);
                        }
                    }
                } else {
                    Package pkg = this.getPackage(packageName);
                    if (pkg == null) {
                        pkg = this.definePackage(packageName, null, null, null, null, null, null, null);
                    } else if (pkg.isSealed()) {
                        LogWrapper.severe("The URL %s is defining elements for sealed path %s", urlConnection.getURL(), packageName);
                    }
                }
            }
            byte[] transformedClass = this.runTransformers(untransformedName, transformedName, this.getClassBytes(untransformedName));
            if (DEBUG_SAVE && transformedName.startsWith("net.minecraft.")) {
                this.saveTransformedClass(transformedClass, transformedName);
            }
            CodeSource codeSource = urlConnection == null ? null : new CodeSource(urlConnection.getURL(), signers);
            Class<?> clazz = this.defineClass(transformedName, transformedClass, 0, transformedClass.length, this.getMetadata((String)transformedName).codeSource);
            this.cachedClasses.put(transformedName, clazz);
            return clazz;
        }
        catch (Throwable e) {
            this.invalidClasses.add(name);
            if (DEBUG) {
                LogWrapper.log(Level.TRACE, e, "Exception encountered attempting classloading of %s", name);
                LogManager.getLogger("LaunchWrapper").log(Level.ERROR, "Exception encountered attempting classloading of %s", e);
            }
            throw new ClassNotFoundException(name, e);
        }
    }

    private KnotClassDelegate.Metadata getMetadata(String name) {
        String fileName = LoaderUtil.getClassFileName(name);
        URL url = this.getResource(fileName);
        if (url == null || !KnotClassDelegate.hasRegularCodeSource(url)) {
            return KnotClassDelegate.Metadata.EMPTY;
        }
        try {
            return this.getMetadata(UrlUtil.getCodeSource(url, fileName));
        }
        catch (UrlConversionException e) {
            throw new RuntimeException(e);
        }
    }

    private KnotClassDelegate.Metadata getMetadata(Path codeSource) {
        return this.metadataCache.computeIfAbsent(codeSource, path -> {
            Certificate[] certificates;
            CodeSource cs;
            Manifest manifest;
            block13: {
                manifest = null;
                cs = null;
                certificates = null;
                try {
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        manifest = ManifestUtil.readManifest(path);
                        break block13;
                    }
                    URLConnection connection = new URL("jar:" + String.valueOf(path.toUri()) + "!/").openConnection();
                    if (connection instanceof JarURLConnection) {
                        manifest = ((JarURLConnection)connection).getManifest();
                        certificates = ((JarURLConnection)connection).getCertificates();
                    }
                    if (manifest != null) break block13;
                    try (FileSystemUtil.FileSystemDelegate jarFs = FileSystemUtil.getJarFileSystem(path, false);){
                        manifest = ManifestUtil.readManifest(jarFs.get().getRootDirectories().iterator().next());
                    }
                }
                catch (IOException | FileSystemNotFoundException connection) {
                    // empty catch block
                }
            }
            if (cs == null) {
                try {
                    cs = new CodeSource(UrlUtil.asUrl(path), certificates);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            return new KnotClassDelegate.Metadata(manifest, cs);
        });
    }

    public String untransformName(String name) {
        return this.renameTransformer != null ? this.renameTransformer.unmapClassName(name) : name;
    }

    public String transformName(String name) {
        return this.renameTransformer != null ? this.renameTransformer.remapClassName(name) : name;
    }

    private boolean isSealed(String path, Manifest manifest) {
        Attributes attributes = manifest.getAttributes(path);
        String sealed = null;
        if (attributes != null) {
            sealed = attributes.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attributes = manifest.getMainAttributes()) != null) {
            sealed = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    private URLConnection findCodeSourceConnectionFor(String name) {
        URL resource = this.findResource(name);
        if (resource != null) {
            try {
                return resource.openConnection();
            }
            catch (IOException var4) {
                throw new RuntimeException(var4);
            }
        }
        return null;
    }

    private void saveTransformedClass(byte[] data, String transformedName) {
        if (tempFolder != null) {
            File outFile = new File(tempFolder, transformedName.replace('.', File.separatorChar) + ".class");
            File outDir = outFile.getParentFile();
            if (!outDir.exists()) {
                outDir.mkdirs();
            }
            if (outFile.exists()) {
                outFile.delete();
            }
            try {
                FileOutputStream output = new FileOutputStream(outFile);
                ((OutputStream)output).write(data);
                ((OutputStream)output).close();
            }
            catch (Exception var6) {
                LogWrapper.log(Level.WARN, var6, "Could not save transformed class \"%s\" to %s", transformedName, outFile.getAbsolutePath());
            }
        }
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
        this.sources.add(url);
    }

    public List<URL> getSources() {
        return this.sources;
    }

    private byte[] readFully(InputStream stream) {
        try {
            byte[] newBuffer;
            int read;
            byte[] buffer = this.getOrCreateBuffer();
            int totalLength = 0;
            while ((read = stream.read(buffer, totalLength, buffer.length - totalLength)) != -1) {
                if ((totalLength += read) < buffer.length - 1) continue;
                newBuffer = new byte[buffer.length + 4096];
                System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
                buffer = newBuffer;
            }
            newBuffer = new byte[totalLength];
            System.arraycopy(buffer, 0, newBuffer, 0, totalLength);
            return newBuffer;
        }
        catch (Throwable var6) {
            LogWrapper.log(Level.WARN, var6, "Problem loading class", new Object[0]);
            return new byte[0];
        }
    }

    private byte[] getOrCreateBuffer() {
        byte[] buffer = this.loadBuffer.get();
        if (buffer == null) {
            this.loadBuffer.set(new byte[4096]);
            buffer = this.loadBuffer.get();
        }
        return buffer;
    }

    public List<IClassTransformer> getTransformers() {
        return Collections.unmodifiableList(this.transformers);
    }

    public IClassNameTransformer getRenameTransformer() {
        return this.renameTransformer;
    }

    public void addClassLoaderExclusion(String toExclude) {
        this.classLoaderExceptions.add(toExclude);
    }

    public void addTransformerExclusion(String toExclude) {
        this.transformerExceptions.add(toExclude);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getClassBytes(String name) throws IOException {
        URL classResource;
        InputStream classStream;
        byte[] data;
        block9: {
            byte[] byArray;
            if (this.negativeResourceCache.contains(name)) {
                return null;
            }
            if (this.resourceCache.containsKey(name)) {
                return this.resourceCache.get(name);
            }
            if (name.indexOf(46) == -1) {
                String[] stringArray = RESERVED_NAMES;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String s;
                    String reservedName = s = stringArray[i];
                    if (!name.toUpperCase(Locale.ENGLISH).startsWith(reservedName) || (data = this.getClassBytes("_" + name)) == null) continue;
                    this.resourceCache.put(name, data);
                    return data;
                }
            }
            classStream = null;
            try {
                String resourcePath = name.replace('.', '/').concat(".class");
                classResource = this.findResource(resourcePath);
                if (classResource != null) break block9;
                if (DEBUG) {
                    LogWrapper.finest("Failed to find class resource %s", resourcePath);
                }
                this.negativeResourceCache.add(name);
                byArray = null;
            }
            catch (Throwable throwable) {
                LaunchClassLoader.closeSilently(classStream);
                throw throwable;
            }
            LaunchClassLoader.closeSilently(classStream);
            return byArray;
        }
        classStream = classResource.openStream();
        if (DEBUG) {
            LogWrapper.finest("Loading class %s from resource %s", name, classResource.toString());
        }
        data = this.readFully(classStream);
        this.resourceCache.put(name, data);
        LaunchClassLoader.closeSilently(classStream);
        return data;
    }

    private static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void clearNegativeEntries(Set<String> entriesToClear) {
        this.negativeResourceCache.removeAll(entriesToClear);
    }

    public byte[] runTransformers(String name, String transformedName, byte[] basicClass) {
        if (DEBUG_FINER) {
            LogWrapper.finest("Beginning transform of {%s (%s)} Start Length: %d", name, transformedName, basicClass == null ? 0 : basicClass.length);
            for (IClassTransformer transformer : this.transformers) {
                String transName = transformer.getClass().getName();
                LogWrapper.finest("Before Transformer {%s (%s)} %s: %d", name, transformedName, transName, basicClass == null ? 0 : basicClass.length);
                basicClass = transformer.transform(name, transformedName, basicClass);
                LogWrapper.finest("After  Transformer {%s (%s)} %s: %d", name, transformedName, transName, basicClass == null ? 0 : basicClass.length);
            }
            LogWrapper.finest("Ending transform of {%s (%s)} Start Length: %d", name, transformedName, basicClass == null ? 0 : basicClass.length);
        } else {
            for (IClassTransformer transformer : this.transformers) {
                basicClass = transformer.transform(name, transformedName, basicClass);
            }
        }
        return basicClass;
    }

    static {
        DEBUG_FINER = DEBUG && (Boolean.parseBoolean(System.getProperty("legacy.debugClassLoadingFiner", "false")) || Configs.Debug.PRINT_CLASSLOAD_INFO.get() != false);
        DEBUG_SAVE = DEBUG && (Boolean.parseBoolean(System.getProperty("legacy.debugClassLoadingSave", "true")) || Configs.Debug.DumpClass.DUMP_CLASS.get() != false);
        tempFolder = null;
        RESERVED_NAMES = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    }
}

