/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.classloading;

import com.chocohead.mm.AsmTransformer;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.accesswidener.AccessWidenerClassVisitor;
import net.xiaoyu233.fml.FishModLoader;
import net.xiaoyu233.fml.classloading.dump.ClassDumper;
import net.xiaoyu233.fml.classloading.dump.DumpStage;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class FMLClassTransformer {
    public static byte[] transform(String name, byte[] bytes, AsmTransformer asmTransformer) {
        ClassVisitor visitor;
        boolean applyAccessWidener;
        boolean isMinecraftClass = name.startsWith("net.minecraft.") || name.startsWith("com.mojang.blaze3d.") || name.indexOf(46) < 0;
        Optional<Consumer<ClassNode>> classModifier = asmTransformer.getClassModifier(name);
        boolean hasTransformation = classModifier.isPresent();
        boolean bl = applyAccessWidener = isMinecraftClass && FishModLoader.getAccessWidener().getTargets().contains(name);
        if (!applyAccessWidener && !hasTransformation) {
            return bytes;
        }
        ClassReader classReader = new ClassReader(bytes);
        ClassWriter classWriter = new ClassWriter(classReader, 0);
        ClassNode classNode = new ClassNode();
        ClassVisitor classVisitor = visitor = hasTransformation ? classNode : classWriter;
        if (applyAccessWidener) {
            visitor = AccessWidenerClassVisitor.createClassVisitor(589824, visitor, FishModLoader.getAccessWidener());
            FishModLoader.LOGGER.info("[AW] Widened class: " + name);
        }
        classReader.accept(visitor, 0);
        if (hasTransformation) {
            if (applyAccessWidener) {
                ClassDumper.dumpClassStaged(classNode, name, DumpStage.ACCESS_WIDENER);
            }
            classModifier.ifPresent(modifier -> modifier.accept(classNode));
            classNode.accept(classWriter);
        }
        byte[] byteArray = classWriter.toByteArray();
        if (hasTransformation) {
            ClassDumper.dumpClassStaged(byteArray, name, DumpStage.CLASS_TINKER);
        } else {
            ClassDumper.dumpClassStaged(byteArray, name, DumpStage.ACCESS_WIDENER);
        }
        return byteArray;
    }
}

