/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.tinyremapper.extension.mixin.soft.annotation.injection;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.tinyremapper.api.TrClass;
import net.fabricmc.tinyremapper.api.TrMember;
import net.fabricmc.tinyremapper.extension.mixin.common.IMappable;
import net.fabricmc.tinyremapper.extension.mixin.common.ResolveUtility;
import net.fabricmc.tinyremapper.extension.mixin.common.data.CommonData;
import net.fabricmc.tinyremapper.extension.mixin.common.data.Pair;
import net.fabricmc.tinyremapper.extension.mixin.soft.annotation.FirstPassAnnotationVisitor;
import net.fabricmc.tinyremapper.extension.mixin.soft.annotation.injection.AtAnnotationVisitor;
import net.fabricmc.tinyremapper.extension.mixin.soft.annotation.injection.DescAnnotationVisitor;
import net.fabricmc.tinyremapper.extension.mixin.soft.annotation.injection.SliceAnnotationVisitor;
import net.fabricmc.tinyremapper.extension.mixin.soft.data.MemberInfo;
import org.objectweb.asm.AnnotationVisitor;

class CommonInjectionAnnotationVisitor
extends FirstPassAnnotationVisitor {
    private final CommonData data;
    private final AnnotationVisitor delegate;
    private final List<String> targets;

    CommonInjectionAnnotationVisitor(String descriptor, CommonData data, AnnotationVisitor delegate, boolean remap, List<String> targets) {
        super(descriptor, remap);
        this.data = Objects.requireNonNull(data);
        this.delegate = Objects.requireNonNull(delegate);
        this.targets = Objects.requireNonNull(targets);
    }

    @Override
    public void visitEnd() {
        this.accept(new CommonInjectionSecondPassAnnotationVisitor(this.data, this.delegate, this.remap, this.targets));
        super.visitEnd();
    }

    private static class CommonInjectionSecondPassAnnotationVisitor
    extends AnnotationVisitor {
        private final CommonData data;
        private final boolean remap;
        private final List<String> targets;

        CommonInjectionSecondPassAnnotationVisitor(CommonData data, AnnotationVisitor delegate, boolean remap, List<String> targets) {
            super(589824, delegate);
            this.data = Objects.requireNonNull(data);
            this.targets = Objects.requireNonNull(targets);
            this.remap = remap;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String descriptor) {
            AnnotationVisitor av = super.visitAnnotation(name, descriptor);
            if (name.equals("at")) {
                if (!descriptor.equals("Lorg/spongepowered/asm/mixin/injection/At;")) {
                    throw new RuntimeException("Unexpected annotation " + descriptor);
                }
                av = new AtAnnotationVisitor(this.data, av, this.remap);
            } else if (name.equals("slice")) {
                if (!descriptor.equals("Lorg/spongepowered/asm/mixin/injection/Slice;")) {
                    throw new RuntimeException("Unexpected annotation " + descriptor);
                }
                av = new SliceAnnotationVisitor(this.data, av, this.remap);
            }
            return av;
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            AnnotationVisitor av = super.visitArray(name);
            if (name.equals("method")) {
                return new AnnotationVisitor(589824, av){

                    @Override
                    public void visit(String name, Object value) {
                        if (remap) {
                            Optional<MemberInfo> info = Optional.ofNullable(MemberInfo.parse(Objects.requireNonNull((String)value).replaceAll("\\s", "")));
                            value = info.map(i -> new InjectMethodMappable(data, (MemberInfo)i, targets).result().toString()).orElse((String)value);
                        }
                        super.visit(name, value);
                    }
                };
            }
            if (this.remap && name.equals("target")) {
                return new AnnotationVisitor(589824, av){

                    @Override
                    public AnnotationVisitor visitAnnotation(String name, String descriptor) {
                        if (!descriptor.equals("Lorg/spongepowered/asm/mixin/injection/Desc;")) {
                            throw new RuntimeException("Unexpected annotation " + descriptor);
                        }
                        AnnotationVisitor av1 = super.visitAnnotation(name, descriptor);
                        return new DescAnnotationVisitor(targets, data, av1, TrMember.MemberType.METHOD);
                    }
                };
            }
            if (name.equals("at")) {
                return new AnnotationVisitor(589824, av){

                    @Override
                    public AnnotationVisitor visitAnnotation(String name, String descriptor) {
                        if (!descriptor.equals("Lorg/spongepowered/asm/mixin/injection/At;")) {
                            throw new RuntimeException("Unexpected annotation " + descriptor);
                        }
                        AnnotationVisitor av1 = super.visitAnnotation(name, descriptor);
                        return new AtAnnotationVisitor(data, av1, remap);
                    }
                };
            }
            if (name.equals("slice")) {
                return new AnnotationVisitor(589824, av){

                    @Override
                    public AnnotationVisitor visitAnnotation(String name, String descriptor) {
                        if (!descriptor.equals("Lorg/spongepowered/asm/mixin/injection/Slice;")) {
                            throw new RuntimeException("Unexpected annotation " + descriptor);
                        }
                        AnnotationVisitor av1 = super.visitAnnotation(name, descriptor);
                        return new SliceAnnotationVisitor(data, av1, remap);
                    }
                };
            }
            return av;
        }
    }

    private static class InjectMethodMappable
    implements IMappable<MemberInfo> {
        private final CommonData data;
        private final MemberInfo info;
        private final List<TrClass> targets;

        InjectMethodMappable(CommonData data, MemberInfo info, List<String> targets) {
            this.data = Objects.requireNonNull(data);
            this.info = Objects.requireNonNull(info);
            this.targets = info.getOwner().isEmpty() ? Objects.requireNonNull(targets).stream().map(data.resolver::resolveClass).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()) : data.resolver.resolveClass(info.getOwner()).map(Collections::singletonList).orElse(Collections.emptyList());
        }

        private Optional<TrMember> resolvePartial(TrClass owner, String name, String desc) {
            Objects.requireNonNull(owner);
            name = name.isEmpty() ? null : name;
            desc = desc.isEmpty() ? null : desc;
            return this.data.resolver.resolveMethod(owner, name, desc, ResolveUtility.FLAG_FIRST | ResolveUtility.FLAG_NON_SYN).map(m -> m);
        }

        @Override
        public MemberInfo result() {
            if (this.targets.isEmpty() || this.info.getName().isEmpty()) {
                return this.info;
            }
            List collection = this.targets.stream().map(target -> this.resolvePartial((TrClass)target, this.info.getName(), this.info.getDesc())).filter(Optional::isPresent).map(Optional::get).map(m -> Pair.of(this.data.mapper.mapName((TrMember)m), this.data.mapper.mapDesc((TrMember)m))).distinct().collect(Collectors.toList());
            if (collection.size() > 1) {
                this.data.logger.error(String.format("Conflict mapping detected, %s -> %s.", this.info.getName(), collection));
            } else if (collection.isEmpty()) {
                this.data.logger.warn(String.format("Cannot remap %s because it does not exists in any of the targets %s", this.info.getName(), this.targets));
            }
            return collection.stream().findFirst().map(pair -> new MemberInfo(this.data.mapper.asTrRemapper().map(this.info.getOwner()), (String)pair.first(), this.info.getQuantifier(), (String)pair.second())).orElse(this.info);
        }
    }
}

