/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.format.srg;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Set;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.MappingFlag;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.ColumnFileReader;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;

public final class JamFileReader {
    private JamFileReader() {
    }

    public static void read(Reader reader, MappingVisitor visitor) throws IOException {
        JamFileReader.read(reader, "source", "target", visitor);
    }

    public static void read(Reader reader, String sourceNs, String targetNs, MappingVisitor visitor) throws IOException {
        JamFileReader.read(new ColumnFileReader(reader, ' '), sourceNs, targetNs, visitor);
    }

    private static void read(ColumnFileReader reader, String sourceNs, String targetNs, MappingVisitor visitor) throws IOException {
        Set<MappingFlag> flags = visitor.getFlags();
        MappingVisitor parentVisitor = null;
        if (flags.contains((Object)MappingFlag.NEEDS_ELEMENT_UNIQUENESS)) {
            parentVisitor = visitor;
            visitor = new MemoryMappingTree();
        } else if (flags.contains((Object)MappingFlag.NEEDS_MULTIPLE_PASSES)) {
            reader.mark();
        }
        while (true) {
            if (visitor.visitHeader()) {
                visitor.visitNamespaces(sourceNs, Collections.singletonList(targetNs));
            }
            if (visitor.visitContent()) {
                String lastClass = null;
                boolean visitLastClass = false;
                do {
                    String dstName;
                    boolean isArg = false;
                    if (reader.nextCol("CL")) {
                        String srcName = reader.nextCol();
                        if (srcName == null || srcName.isEmpty()) {
                            throw new IOException("missing class-name-a in line " + reader.getLineNumber());
                        }
                        if (srcName.equals(lastClass)) continue;
                        lastClass = srcName;
                        visitLastClass = visitor.visitClass(srcName);
                        if (!visitLastClass) continue;
                        String dstName2 = reader.nextCol();
                        if (dstName2 == null || dstName2.isEmpty()) {
                            throw new IOException("missing class-name-b in line " + reader.getLineNumber());
                        }
                        visitor.visitDstName(MappedElementKind.CLASS, 0, dstName2);
                        visitLastClass = visitor.visitElementContent(MappedElementKind.CLASS);
                        continue;
                    }
                    boolean isMethod = reader.nextCol("MD");
                    if (!isMethod && !reader.nextCol("FD") && !(isArg = reader.nextCol("MP"))) continue;
                    String clsSrcClsName = reader.nextCol();
                    if (clsSrcClsName == null) {
                        throw new IOException("missing class-name-a in line " + reader.getLineNumber());
                    }
                    String memberSrcName = reader.nextCol();
                    if (memberSrcName == null || memberSrcName.isEmpty()) {
                        throw new IOException("missing member-name-a in line " + reader.getLineNumber());
                    }
                    String memberSrcDesc = reader.nextCol();
                    if (memberSrcDesc == null || memberSrcDesc.isEmpty()) {
                        throw new IOException("missing member-desc-a in line " + reader.getLineNumber());
                    }
                    String col5 = reader.nextCol();
                    String col6 = reader.nextCol();
                    String col7 = reader.nextCol();
                    int argSrcPos = -1;
                    if (!isArg) {
                        dstName = col5;
                    } else {
                        argSrcPos = Integer.parseInt(col5);
                        if (col7 == null || col7.isEmpty()) {
                            dstName = col6;
                        } else {
                            String argSrcDesc = col6;
                            if (argSrcDesc == null || argSrcDesc.isEmpty()) {
                                throw new IOException("missing parameter-desc-a in line " + reader.getLineNumber());
                            }
                            dstName = col7;
                        }
                    }
                    if (dstName == null || dstName.isEmpty()) {
                        throw new IOException("missing name-b in line " + reader.getLineNumber());
                    }
                    if (!clsSrcClsName.equals(lastClass)) {
                        lastClass = clsSrcClsName;
                        visitLastClass = visitor.visitClass(clsSrcClsName);
                        if (visitLastClass) {
                            visitLastClass = visitor.visitElementContent(MappedElementKind.CLASS);
                        }
                    }
                    if (!visitLastClass) continue;
                    boolean visitMethod = false;
                    if (isMethod || isArg) {
                        visitMethod = visitor.visitMethod(memberSrcName, memberSrcDesc);
                    }
                    if (visitMethod) {
                        if (isMethod) {
                            visitor.visitDstName(MappedElementKind.METHOD, 0, dstName);
                            visitor.visitElementContent(MappedElementKind.METHOD);
                            continue;
                        }
                        visitor.visitMethodArg(argSrcPos, -1, null);
                        visitor.visitDstName(MappedElementKind.METHOD_ARG, 0, dstName);
                        visitor.visitElementContent(MappedElementKind.METHOD_ARG);
                        continue;
                    }
                    if (isMethod || isArg || !visitor.visitField(memberSrcName, memberSrcDesc)) continue;
                    visitor.visitDstName(MappedElementKind.FIELD, 0, dstName);
                    visitor.visitElementContent(MappedElementKind.FIELD);
                } while (reader.nextLine(0));
            }
            if (visitor.visitEnd()) break;
            reader.reset();
        }
        if (parentVisitor != null) {
            ((MappingTree)((Object)visitor)).accept(parentVisitor);
        }
    }
}

