/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.format;

import org.jetbrains.annotations.Nullable;

public enum MappingFormat {
    TINY_FILE("Tiny file", "tiny", true, true, false, false, false, true),
    TINY_2_FILE("Tiny v2 file", "tiny", true, true, true, true, true, true),
    ENIGMA_FILE("Enigma file", "mapping", false, true, true, true, false, true),
    ENIGMA_DIR("Enigma directory", null, false, true, true, true, false, true),
    SRG_FILE("SRG file", "srg", false, false, false, false, false, true),
    XSRG_FILE("XSRG file", "xsrg", false, true, false, false, false, true),
    JAM_FILE("JAM file", "jam", false, true, false, true, false, true),
    CSRG_FILE("CSRG file", "csrg", false, false, false, false, false, true),
    TSRG_FILE("TSRG file", "tsrg", false, false, false, false, false, true),
    TSRG_2_FILE("TSRG2 file", "tsrg", true, true, false, true, false, true),
    PROGUARD_FILE("ProGuard file", "txt", false, true, false, false, false, true),
    RECAF_SIMPLE_FILE("Recaf Simple file", "txt", false, true, false, false, false, true),
    JOBF_FILE("JOBF file", "jobf", false, true, false, false, false, true);

    public final String name;
    @Nullable
    public final String fileExt;
    public final boolean hasNamespaces;
    public final boolean hasFieldDescriptors;
    public final boolean supportsComments;
    public final boolean supportsArgs;
    public final boolean supportsLocals;
    public final boolean hasWriter;

    private MappingFormat(String name, String fileExt, boolean hasNamespaces, boolean hasFieldDescriptors, boolean supportsComments, boolean supportsArgs, boolean supportsLocals, boolean hasWriter) {
        this.name = name;
        this.fileExt = fileExt;
        this.hasNamespaces = hasNamespaces;
        this.hasFieldDescriptors = hasFieldDescriptors;
        this.supportsComments = supportsComments;
        this.supportsArgs = supportsArgs;
        this.supportsLocals = supportsLocals;
        this.hasWriter = hasWriter;
    }

    public boolean hasSingleFile() {
        return this.fileExt != null;
    }

    public String getGlobPattern() {
        if (this.fileExt == null) {
            throw new UnsupportedOperationException("not applicable to dir based format");
        }
        return "*." + this.fileExt;
    }
}

