/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.util.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import net.fabricmc.loader.impl.util.log.LogCategory;
import net.fabricmc.loader.impl.util.log.LogHandler;
import net.fabricmc.loader.impl.util.log.LogLevel;

public class ConsoleLogHandler
implements LogHandler {
    private static final LogLevel MIN_STDERR_LEVEL = LogLevel.ERROR;
    private static final LogLevel MIN_STDOUT_LEVEL = LogLevel.getDefault();

    protected static String formatLog(long time, LogLevel level, LogCategory category, String msg, Throwable exc) {
        String ret = String.format("[%tT] [%s] [%s/%s]: %s%n", time, level.name(), category.context, category.name, msg);
        if (exc != null) {
            StringWriter writer = new StringWriter(ret.length() + 500);
            try (PrintWriter pw = new PrintWriter((Writer)writer, false);){
                pw.print(ret);
                exc.printStackTrace(pw);
            }
            ret = writer.toString();
        }
        return ret;
    }

    @Override
    public void log(long time, LogLevel level, LogCategory category, String msg, Throwable exc, boolean fromReplay, boolean wasSuppressed) {
        String formatted = ConsoleLogHandler.formatLog(time, level, category, msg, exc);
        if (level.isLessThan(MIN_STDERR_LEVEL)) {
            System.out.print(formatted);
        } else {
            System.err.print(formatted);
        }
    }

    @Override
    public boolean shouldLog(LogLevel level, LogCategory category) {
        return !level.isLessThan(MIN_STDOUT_LEVEL);
    }

    @Override
    public void close() {
    }
}

