/*
 * Decompiled with CFR 0.152.
 */
package javax.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.annotation.meta.TypeQualifier;
import javax.annotation.meta.TypeQualifierValidator;
import javax.annotation.meta.When;

@Documented
@TypeQualifier(applicableTo=Number.class)
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Nonnegative {
    public When when() default When.ALWAYS;

    public static class Checker
    implements TypeQualifierValidator<Nonnegative> {
        @Override
        public When forConstantValue(Nonnegative annotation, Object v) {
            if (!(v instanceof Number)) {
                return When.NEVER;
            }
            Number value = (Number)v;
            boolean isNegative = value instanceof Long ? value.longValue() < 0L : (value instanceof Double ? value.doubleValue() < 0.0 : (value instanceof Float ? value.floatValue() < 0.0f : value.intValue() < 0));
            return isNegative ? When.NEVER : When.ALWAYS;
        }
    }
}

