/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.spongepowered.asm.util.asm.ASM;

public class GenericParamParser
extends SignatureVisitor {
    private final List<Type> results = new ArrayList<Type>();

    private GenericParamParser() {
        super(ASM.API_VERSION);
    }

    public static List<Type> getParameterGenerics(String desc, String signature) {
        if (signature == null || signature.isEmpty()) {
            return Collections.nCopies(Type.getArgumentTypes(desc).length, null);
        }
        GenericParamParser parser = new GenericParamParser();
        new SignatureReader(signature).accept(parser);
        return parser.results;
    }

    @Override
    public SignatureVisitor visitParameterType() {
        final int index = this.results.size();
        this.results.add(null);
        return new SignatureVisitor(this.api){

            @Override
            public SignatureVisitor visitTypeArgument(char wildcard) {
                if (wildcard != '=') {
                    return this;
                }
                return new SignatureVisitor(this.api){
                    private int depth;
                    private int arrayDimensions;
                    private String internalName;

                    @Override
                    public SignatureVisitor visitArrayType() {
                        if (this.depth == 0) {
                            ++this.arrayDimensions;
                        }
                        return this;
                    }

                    @Override
                    public void visitBaseType(char descriptor) {
                        if (this.depth == 0) {
                            GenericParamParser.this.results.set(index, Type.getType(StringUtils.repeat((char)'[', (int)this.arrayDimensions) + descriptor));
                        }
                    }

                    @Override
                    public void visitClassType(String name) {
                        if (++this.depth == 1) {
                            this.internalName = name;
                        }
                    }

                    @Override
                    public void visitInnerClassType(String name) {
                        if (this.depth == 1) {
                            this.internalName = this.internalName + "$" + name;
                        }
                    }

                    @Override
                    public void visitEnd() {
                        --this.depth;
                        String prefix = StringUtils.repeat((char)'[', (int)this.arrayDimensions);
                        GenericParamParser.this.results.set(index, Type.getType(prefix + Type.getObjectType(this.internalName).getDescriptor()));
                    }
                };
            }
        };
    }
}

