/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.mm.api;

import com.chocohead.mm.api.ClassTinkerers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.objectweb.asm.Type;

public final class EnumAdder {
    public final String type;
    public final Type[] parameterTypes;
    private final List<EnumAddition> additions = new ArrayList<EnumAddition>();
    private boolean finished = false;

    EnumAdder(String type, Class<?> ... parameterTypes) {
        this(type, (Type[])Arrays.stream(parameterTypes).map(Type::getType).toArray(Type[]::new));
    }

    EnumAdder(String type, String ... parameterTypes) {
        this(type, (Type[])Arrays.stream(parameterTypes).map(Type::getType).toArray(Type[]::new));
    }

    EnumAdder(String enumType, Object ... parameterTypes) {
        this(enumType, (Type[])Arrays.stream(parameterTypes).map(type -> {
            if (type.getClass() == Type.class) {
                return (Type)type;
            }
            if (type.getClass() == String.class) {
                return Type.getType(((String)type).replace('.', '/'));
            }
            if (type.getClass() == Class.class) {
                if (((Class)type).getName().startsWith("net.minecraft.")) {
                    throw new IllegalArgumentException("Early loaded " + ((Class)type).getName());
                }
                return Type.getType((Class)type);
            }
            throw new IllegalArgumentException("Unsure how to map parameter type " + String.valueOf(type.getClass()) + " (from " + String.valueOf(type) + ")");
        }).toArray(Type[]::new));
    }

    private EnumAdder(String type, Type[] parameterTypes) {
        this.type = type;
        this.parameterTypes = parameterTypes;
    }

    public EnumAdder addEnum(String name, Object ... parameters) {
        if (this.finished) {
            throw new IllegalStateException("Attempted to add onto a built EnumAdder");
        }
        if (name == null) {
            throw new NullPointerException("Null name attempted to be added to " + this.type);
        }
        this.checkParameters(parameters);
        this.additions.add(new EnumAddition(name, () -> parameters));
        return this;
    }

    public EnumAdder addEnum(String name, Supplier<Object[]> parameterFactory) {
        if (this.finished) {
            throw new IllegalStateException("Attempted to add onto a built EnumAdder");
        }
        if (name == null) {
            throw new NullPointerException("Null name attempted to be added to " + this.type);
        }
        if (parameterFactory == null) {
            throw new NullPointerException("Null parameter factory provided to make " + name + " of " + this.type);
        }
        this.additions.add(new EnumAddition(name, parameterFactory));
        return this;
    }

    public EnumAdder addEnumSubclass(String name, String structClass, Object ... parameters) {
        if (this.finished) {
            throw new IllegalStateException("Attempted to add onto a built EnumAdder");
        }
        if (name == null) {
            throw new NullPointerException("Null name attempted to be added to " + this.type);
        }
        if (structClass == null) {
            throw new IllegalArgumentException("Null structClass provided to make " + name + " of " + this.type);
        }
        this.checkParameters(parameters);
        this.additions.add(new EnumAddition(name, structClass.replace('.', '/'), () -> parameters));
        return this;
    }

    public EnumAdder addEnumSubclass(String name, String structClass, Supplier<Object[]> parameterFactory) {
        if (this.finished) {
            throw new IllegalStateException("Attempted to add onto a built EnumAdder");
        }
        if (name == null) {
            throw new NullPointerException("Null name attempted to be added to " + this.type);
        }
        if (structClass == null) {
            throw new IllegalArgumentException("Null structClass provided to make " + name + " of " + this.type);
        }
        if (parameterFactory == null) {
            throw new NullPointerException("Null parameter factory provided to make " + name + " of " + this.type);
        }
        this.additions.add(new EnumAddition(name, structClass.replace('.', '/'), parameterFactory));
        return this;
    }

    Object[] checkParameters(Object[] parameters) {
        if (parameters.length != this.parameterTypes.length) {
            throw new IllegalArgumentException("Differing number of parameters provided for types expected");
        }
        return parameters;
    }

    public boolean hasParameters() {
        return this.parameterTypes.length > 0;
    }

    public void build() {
        ClassTinkerers.addEnum(this);
        this.finished = true;
    }

    public Collection<EnumAddition> getAdditions() {
        return Collections.unmodifiableCollection(this.additions);
    }

    public boolean willSubclass() {
        for (EnumAddition addition : this.additions) {
            if (!addition.isEnumSubclass()) continue;
            return true;
        }
        return false;
    }

    public final class EnumAddition {
        public final String name;
        public final String structClass;
        private final Supplier<Object[]> parameterFactory;

        EnumAddition(String name, Supplier<Object[]> parameterFactory) {
            this(name, null, parameterFactory);
        }

        EnumAddition(String name, String structClass, Supplier<Object[]> parameterFactory) {
            this.name = name;
            this.structClass = structClass;
            this.parameterFactory = parameterFactory;
        }

        public Object[] getParameters() {
            return EnumAdder.this.checkParameters(this.parameterFactory.get());
        }

        public boolean isEnumSubclass() {
            return this.structClass != null;
        }
    }
}

