/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.mm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.Permission;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;

public final class CasualStreamHandler
extends URLStreamHandler {
    static BiConsumer<String, byte[]> dumper;
    private final Map<String, byte[]> providers;

    public CasualStreamHandler(Map<String, byte[]> providers) {
        this.providers = providers;
    }

    public static URL create(String name, byte[] stream) {
        return CasualStreamHandler.create(Collections.singletonMap("/" + name.replace('.', '/') + ".class", stream));
    }

    public static URL create(Map<String, byte[]> mixins) {
        try {
            return new URL("magic-at", null, -1, "/", new CasualStreamHandler(mixins));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unexpected error creating URL", e);
        }
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        if (!this.providers.containsKey(url.getPath())) {
            return null;
        }
        return new CasualConnection(url, this.providers.get(url.getPath()));
    }

    private static final class CasualConnection
    extends URLConnection {
        private final byte[] realStream;

        public CasualConnection(URL url, byte[] realStream) {
            super(url);
            this.realStream = realStream;
        }

        @Override
        public void connect() throws IOException {
            System.out.println("Connection attempt");
            throw new UnsupportedOperationException();
        }

        @Override
        public InputStream getInputStream() {
            if (dumper == null) {
                System.err.println("Asked for " + this.url.getPath() + " too early to export");
            } else {
                dumper.accept(this.url.getPath().substring(1, this.url.getPath().length() - 6).replace('/', '.'), this.realStream);
            }
            return new ByteArrayInputStream(this.realStream);
        }

        @Override
        public Permission getPermission() {
            return null;
        }
    }
}

