/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.mm;

import com.chocohead.mm.CasualStreamHandler;
import com.chocohead.mm.EnumExtender;
import com.chocohead.mm.EnumSubclasser;
import com.chocohead.mm.UnremovableMap;
import com.chocohead.mm.api.ClassTinkerers;
import com.chocohead.mm.api.EnumAdder;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;
import org.spongepowered.asm.mixin.transformer.ext.extensions.ExtensionClassExporter;

public final class AsmTransformer {
    private static final int ACCESSES = -8;
    final Map<String, String> enumStructParents = new HashMap<String, String>();
    private final Map<String, Set<Consumer<ClassNode>>> classModifiers = new HashMap<String, Set<Consumer<ClassNode>>>();
    private final Map<String, Consumer<ClassNode>> classReplacers = new HashMap<String, Consumer<ClassNode>>(){
        private static final long serialVersionUID = -1226882557534215762L;
        private boolean skipGen = false;

        @Override
        public Consumer<ClassNode> put(String key, Consumer<ClassNode> value) {
            if (!this.skipGen && !AsmTransformer.this.classModifiers.containsKey(key)) {
                AsmTransformer.this.classModifiers.put(key, new HashSet());
            }
            return super.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Consumer<ClassNode>> m) {
            this.skipGen = true;
            AsmTransformer.this.classModifiers.putAll(Maps.asMap(m.keySet(), name -> AsmTransformer.this.classModifiers.getOrDefault(name, new HashSet())));
            super.putAll(m);
            this.skipGen = false;
        }
    };
    private final Set<EnumAdder> enumExtenders = new HashSet<EnumAdder>(){
        private static final long serialVersionUID = -2218861530200989346L;
        private boolean skipCheck = false;

        private void addTransformations(EnumAdder builder) {
            ClassTinkerers.addTransformation(builder.type, EnumExtender.makeEnumExtender(builder));
            for (EnumAdder.EnumAddition addition : builder.getAdditions()) {
                if (!addition.isEnumSubclass()) continue;
                ClassTinkerers.addReplacement(addition.structClass, EnumSubclasser.makeStructFixer(addition, builder.type));
                for (EnumSubclasser.StructClass node : EnumSubclasser.getParentStructs(addition.structClass)) {
                    String lastEnum = AsmTransformer.this.enumStructParents.put(node.name, builder.type);
                    assert (lastEnum == null || lastEnum.equals(builder.type));
                }
            }
            AsmTransformer.this.enumStructParents.keySet().removeAll(AsmTransformer.this.classReplacers.keySet());
        }

        @Override
        public boolean add(EnumAdder builder) {
            if (!this.skipCheck) {
                this.addTransformations(builder);
            }
            return super.add(builder);
        }

        @Override
        public boolean addAll(Collection<? extends EnumAdder> builders) {
            this.skipCheck = true;
            for (EnumAdder enumAdder : builders) {
                this.addTransformations(enumAdder);
            }
            boolean out = super.addAll(builders);
            this.skipCheck = false;
            return out;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super EnumAdder> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    };

    private static Consumer<ClassNode> makeAT(Set<String> transforms) {
        return node -> {
            if (transforms.remove("<*>")) {
                node.access = AsmTransformer.flipBits(node.access);
                for (InnerClassNode innerClass : node.innerClasses) {
                    if (!node.name.equals(innerClass.name)) continue;
                    innerClass.access = AsmTransformer.flipBits(innerClass.access);
                    break;
                }
            }
            if (!transforms.isEmpty()) {
                for (MethodNode method : node.methods) {
                    if (transforms.contains(method.name + method.desc)) {
                        method.access = AsmTransformer.flipBits(method.access);
                    }
                    for (AbstractInsnNode insnNode : method.instructions) {
                        if (insnNode.getOpcode() != 183) continue;
                        MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
                        if (methodInsnNode.name.equals("<init>") || !methodInsnNode.owner.equals(node.name) || !transforms.contains(methodInsnNode.name + methodInsnNode.desc)) continue;
                        methodInsnNode.setOpcode(182);
                    }
                }
            }
        };
    }

    private static int flipBits(int access) {
        access &= 0xFFFFFFF8;
        access |= 1;
        return access &= 0xFFFFFFEF;
    }

    private static void initializeSilkyAT() {
        HashMap<String, Set> transforms = new HashMap<String, Set>();
        try {
            Enumeration<URL> urls = AsmTransformer.class.getClassLoader().getResources("silky.at");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                try (Scanner scanner = new Scanner(url.openStream());){
                    while (scanner.hasNextLine()) {
                        String method;
                        String className;
                        String line = scanner.nextLine().trim();
                        if (line.isEmpty() || line.startsWith("#")) continue;
                        int split = line.indexOf(32);
                        if (split > 0) {
                            className = line.substring(0, split++);
                            method = line.substring(split);
                        } else {
                            className = line;
                            method = "<*>";
                        }
                        transforms.computeIfAbsent(className, k -> new HashSet()).add(method);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading access transformers", e);
        }
        for (Map.Entry entry : transforms.entrySet()) {
            ClassTinkerers.addTransformation((String)entry.getKey(), AsmTransformer.makeAT((Set)entry.getValue()));
        }
    }

    public void buildAndInitializeTransformer(Consumer<URL> urlAdder) {
        HashMap<String, byte[]> classGenerators = new HashMap<String, byte[]>();
        if (!this.enumStructParents.isEmpty()) {
            for (Map.Entry<String, String> entry : this.enumStructParents.entrySet()) {
                ClassTinkerers.addReplacement(entry.getKey(), EnumSubclasser.makeStructFixer(entry.getKey(), entry.getValue()));
            }
        }
        ClassTinkerers.addURL(CasualStreamHandler.create(classGenerators));
        ClassTinkerers.INSTANCE.buildTinkerers(urlAdder, new UnremovableMap<String, byte[]>(classGenerators), new UnremovableMap<String, Consumer<ClassNode>>(this.classReplacers), new UnremovableMap<String, Set<Consumer<ClassNode>>>(this.classModifiers), this.enumExtenders);
        Object transformer = MixinEnvironment.getCurrentEnvironment().getActiveTransformer();
        if (transformer == null) {
            throw new IllegalStateException("Not running with a transformer?");
        }
        Extensions extensions = null;
        try {
            for (Field f2 : transformer.getClass().getDeclaredFields()) {
                if (f2.getType() != Extensions.class) continue;
                f2.setAccessible(true);
                extensions = (Extensions)f2.get(transformer);
                break;
            }
            if (extensions == null) {
                String foundFields = Arrays.stream(transformer.getClass().getDeclaredFields()).map(f -> String.valueOf(f.getType()) + " " + f.getName()).collect(Collectors.joining(", "));
                throw new NoSuchFieldError("Unable to find extensions field, only found " + foundFields);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Running with a transformer that doesn't have extensions?", e);
        }
        ExtensionClassExporter exporter = (ExtensionClassExporter)extensions.getExtension(ExtensionClassExporter.class);
        CasualStreamHandler.dumper = (name, bytes) -> {
            ClassNode node = new ClassNode();
            new ClassReader((byte[])bytes).accept(node, 8);
            exporter.export(MixinEnvironment.getCurrentEnvironment(), (String)name, false, node);
        };
        System.out.println("ClassTinkerers initialized.");
    }

    public Optional<Consumer<ClassNode>> getClassModifier(String className) {
        String newClassName = className.replace('.', '/');
        if (!this.classModifiers.containsKey(newClassName) && !this.classReplacers.containsKey(newClassName)) {
            return Optional.empty();
        }
        Consumer<ClassNode> classModifiers = node -> this.applyClassModifies(newClassName, (ClassNode)node);
        return Optional.ofNullable(this.classReplacers.get(newClassName)).map(replacer -> replacer.andThen(classModifiers)).or(() -> Optional.of(classModifiers));
    }

    private void applyClassModifies(String targetClassName, ClassNode targetClass) {
        Set<Consumer<ClassNode>> transformations = this.classModifiers.get(targetClassName);
        if (transformations != null) {
            System.out.println("[ClassTinkerer] Modifying class:" + targetClassName);
            for (Consumer<ClassNode> transformer : transformations) {
                transformer.accept(targetClass);
            }
        }
    }
}

