/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.random;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import moddedmite.rustedironcore.random.FloatWeightedEntry;
import moddedmite.rustedironcore.random.IntegerWeightedEntry;

public class RandomUtil {
    public static <T extends IntegerWeightedEntry> T getRandomEntry(List<T> list, Random random) {
        IntegerWeightedEntry chosen;
        int total = RandomUtil.getTotalWeight(list);
        int randomInt = random.nextInt(total);
        Iterator<T> iterator = list.iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while ((randomInt -= (chosen = (IntegerWeightedEntry)iterator.next()).getWeight()) >= 0);
        return (T)chosen;
    }

    public static <T extends IntegerWeightedEntry> int getTotalWeight(List<T> list) {
        int result = 0;
        for (IntegerWeightedEntry t : list) {
            result += t.getWeight();
        }
        return result;
    }

    public static <T extends FloatWeightedEntry> T getRandomEntryFloat(List<T> list, Random random) {
        FloatWeightedEntry chosen;
        float total = RandomUtil.getTotalWeightFloat(list);
        float randomFloat = random.nextFloat(total);
        Iterator<T> iterator = list.iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while ((randomFloat -= (chosen = (FloatWeightedEntry)iterator.next()).getWeight()) >= 0.0f);
        return (T)chosen;
    }

    public static <T extends FloatWeightedEntry> float getTotalWeightFloat(List<T> list) {
        float result = 0.0f;
        for (FloatWeightedEntry t : list) {
            result += t.getWeight();
        }
        return result;
    }

    public static <T> T getRandom(List<T> list, Random random) {
        return list.get(random.nextInt(list.size()));
    }
}

