/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.network;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import moddedmite.rustedironcore.api.util.FabricUtil;
import moddedmite.rustedironcore.network.Packet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.ServerPlayer;
import net.minecraft.server.MinecraftServer;

public class Network {
    private static BiConsumer<ServerPlayer, Packet> clientSender;
    private static Consumer<Packet> serverSender;

    public static void initServer(BiConsumer<ServerPlayer, Packet> sender) {
        clientSender = sender;
    }

    public static void initClient(Consumer<Packet> sender) {
        serverSender = sender;
    }

    @Environment(value=EnvType.SERVER)
    public static void sendToClient(ServerPlayer player, Packet packet) {
        clientSender.accept(player, packet);
    }

    @Environment(value=EnvType.SERVER)
    public static void sendToAllPlayers(Packet packet) {
        MinecraftServer.getServer().getConfigurationManager().sendPacketToAllPlayers((net.minecraft.Packet)packet.toVanilla());
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(Packet packet) {
        if (FabricUtil.isServer()) {
            throw new IllegalCallerException("don't let the server send packet to itself: " + String.valueOf(packet.getChannel()));
        }
        serverSender.accept(packet);
    }
}

