/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.mixin.util;

import huix.glacier.api.extension.item.IRetainableItem;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import moddedmite.rustedironcore.api.event.events.CraftingRecipeRegisterEvent;
import moddedmite.rustedironcore.api.interfaces.IRecipeExtend;
import moddedmite.rustedironcore.property.ItemProperties;
import net.minecraft.Block;
import net.minecraft.BlockWorkbench;
import net.minecraft.CraftingResult;
import net.minecraft.EntityPlayer;
import net.minecraft.IInventory;
import net.minecraft.IRecipe;
import net.minecraft.Item;
import net.minecraft.ItemCoin;
import net.minecraft.ItemStack;
import net.minecraft.ShapedRecipes;
import net.minecraft.ShapelessRecipes;
import net.minecraft.Slot;
import net.minecraft.SlotCrafting;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={SlotCrafting.class})
public abstract class SlotCraftingMixin
extends Slot {
    @Shadow
    public CraftingResult crafting_result;
    @Shadow
    private int amountCrafted;
    @Shadow
    @Final
    private IInventory craftMatrix;
    @Shadow
    private EntityPlayer thePlayer;

    public SlotCraftingMixin(IInventory inventory, int slot_index, int display_x, int display_y) {
        super(inventory, slot_index, display_x, display_y);
    }

    @Shadow
    protected abstract void onCrafting(ItemStack var1, int var2);

    @Overwrite
    public void onPickupFromSlot(EntityPlayer par1EntityPlayer, ItemStack resultItemStack) {
        int consumption = this.crafting_result.consumption;
        this.amountCrafted = resultItemStack.stackSize;
        this.onCrafting(resultItemStack);
        par1EntityPlayer.inventory.addItemStackToInventoryOrDropIt(resultItemStack.copy());
        int xp_reclaimed = 0;
        List<CraftingRecipeRegisterEvent.ConsumeRule> consumeOverride = this.getConsumeOverride();
        for (int slotIndex = 0; slotIndex < this.craftMatrix.getSizeInventory(); ++slotIndex) {
            Optional<CraftingRecipeRegisterEvent.ConsumeRule> optional1;
            Optional<UnaryOperator<ItemStack>> optional;
            Item container_item;
            ItemStack itemStackInSlot = this.craftMatrix.getStackInSlot(slotIndex);
            if (itemStackInSlot == null) continue;
            Item item = itemStackInSlot.getItem();
            if (item instanceof ItemCoin) {
                ItemCoin coin = (ItemCoin)item;
                xp_reclaimed += coin.getExperienceValue();
            }
            this.craftMatrix.decrStackSize(slotIndex, consumption);
            if (itemStackInSlot.getItem().hasContainerItem()) {
                ItemStack emptyContainer = new ItemStack(itemStackInSlot.getItem().getContainerItem());
                container_item = emptyContainer.getItem();
                if (container_item.getClass() == resultItemStack.getItem().getClass() || itemStackInSlot.getItem().doesContainerItemLeaveCraftingGrid(itemStackInSlot) && this.thePlayer.inventory.addItemStackToInventory(emptyContainer)) continue;
                if (this.craftMatrix.getStackInSlot(slotIndex) == null) {
                    this.craftMatrix.setInventorySlotContents(slotIndex, emptyContainer);
                    continue;
                }
                this.thePlayer.dropPlayerItem(emptyContainer);
                continue;
            }
            if (itemStackInSlot.itemID == Block.workbench.blockID) {
                this.thePlayer.inventory.addItemStackToInventoryOrDropIt(BlockWorkbench.getBlockComponent((int)itemStackInSlot.getItemSubtype()));
                continue;
            }
            container_item = itemStackInSlot.getItem();
            if (container_item instanceof IRetainableItem) {
                IRetainableItem iRetainableItem = (IRetainableItem)container_item;
                this.craftMatrix.setInventorySlotContents(slotIndex, iRetainableItem.getItemStackAfterCrafting(itemStackInSlot));
            }
            if ((optional = ItemProperties.CraftConsumeOverride.getOptional(itemStackInSlot.getItem())).isPresent()) {
                this.craftMatrix.setInventorySlotContents(slotIndex, (ItemStack)optional.get().apply(itemStackInSlot));
                continue;
            }
            if (consumeOverride == null || !(optional1 = consumeOverride.stream().filter(x -> x.matches(itemStackInSlot)).findFirst()).isPresent() || this.craftMatrix.getStackInSlot(slotIndex) != null) continue;
            this.craftMatrix.setInventorySlotContents(slotIndex, optional1.get().apply(itemStackInSlot));
        }
        if (xp_reclaimed > 0) {
            par1EntityPlayer.addExperience(xp_reclaimed, true, false);
        }
    }

    @Nullable
    @Unique
    private List<CraftingRecipeRegisterEvent.ConsumeRule> getConsumeOverride() {
        IRecipe recipe = this.crafting_result.recipe;
        if (recipe instanceof ShapedRecipes) {
            ShapedRecipes shaped = (ShapedRecipes)recipe;
            return ((IRecipeExtend)shaped).ric$GetConsumeRules();
        }
        if (recipe instanceof ShapelessRecipes) {
            ShapelessRecipes shapeless = (ShapelessRecipes)recipe;
            return ((IRecipeExtend)shapeless).ric$GetConsumeRules();
        }
        return null;
    }
}

