/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.mixin.util;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Comparator;
import java.util.List;
import moddedmite.rustedironcore.api.event.Handlers;
import moddedmite.rustedironcore.api.event.events.CraftingRecipeRegisterEvent;
import moddedmite.rustedironcore.internal.event.Hooks;
import net.minecraft.CraftingManager;
import net.minecraft.CraftingResult;
import net.minecraft.EntityPlayer;
import net.minecraft.InventoryCrafting;
import net.minecraft.ItemStack;
import net.minecraft.ShapedRecipes;
import net.minecraft.ShapelessRecipes;
import net.minecraft.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={CraftingManager.class})
public abstract class CraftingManagerMixin {
    @Shadow
    public abstract ShapedRecipes addRecipe(ItemStack var1, boolean var2, Object ... var3);

    @Shadow
    public abstract ShapelessRecipes addShapelessRecipe(ItemStack var1, boolean var2, Object ... var3);

    @WrapOperation(method={"<init>"}, at={@At(value="INVOKE", target="Ljava/util/Collections;sort(Ljava/util/List;Ljava/util/Comparator;)V")})
    private <T> void postRecipes(List<T> list, Comparator<? super T> c, Operation<Void> original) {
        CraftingRecipeRegisterEvent craftingRecipeRegisterEvent = new CraftingRecipeRegisterEvent();
        Handlers.Crafting.publish(craftingRecipeRegisterEvent);
        for (CraftingRecipeRegisterEvent.RecipeArgs shaped : craftingRecipeRegisterEvent.getShaped()) {
            ShapedRecipes shapedRecipes = this.addRecipe(shaped.result, shaped.include_in_lowest_crafting_difficulty_determination, shaped.inputs);
            shaped.modifyShapedRecipe(shapedRecipes);
        }
        for (CraftingRecipeRegisterEvent.RecipeArgs shapeless : craftingRecipeRegisterEvent.getShapeless()) {
            ShapelessRecipes shapelessRecipes = this.addShapelessRecipe(shapeless.result, shapeless.include_in_lowest_crafting_difficulty_determination, shapeless.inputs);
            shapeless.modifyShapelessRecipe(shapelessRecipes);
        }
        original.call(new Object[]{list, c});
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        Hooks.postCraftingRecipeRegister();
    }

    @Inject(method={"findMatchingRecipe"}, at={@At(value="INVOKE", target="Lnet/minecraft/InventoryCrafting;getEventHandler()Lnet/minecraft/Container;")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void repairArmor(InventoryCrafting par1InventoryCrafting, World par2World, EntityPlayer player, CallbackInfoReturnable<CraftingResult> cir, int var3, ItemStack var4, ItemStack var5, int var6) {
        if (var3 != 2 || var4 == null || var5 == null) {
            return;
        }
        CraftingResult match = Handlers.Crafting.repairArmor(player, var4, var5);
        if (match == null) {
            cir.setReturnValue(null);
            return;
        }
        if (match.isRepair()) {
            cir.setReturnValue((Object)match);
        }
    }
}

