/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.mixin.tileEntity;

import huix.glacier.api.extension.item.IFusibleItem;
import huix.glacier.api.registry.MinecraftRegistry;
import moddedmite.rustedironcore.api.event.Handlers;
import moddedmite.rustedironcore.api.event.handler.SmeltingHandler;
import moddedmite.rustedironcore.property.ItemProperties;
import net.minecraft.BlockFurnace;
import net.minecraft.EnumBlockFX;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.minecraft.TileEntity;
import net.minecraft.TileEntityFurnace;
import net.minecraft.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TileEntityFurnace.class})
public abstract class TileEntityFurnaceMixin
extends TileEntity {
    @Shadow
    public int heat_level;
    @Shadow
    public int furnaceBurnTime;
    @Shadow
    public int currentItemBurnTime;
    @Shadow
    private ItemStack[] furnaceItemStacks;
    @Shadow
    public int furnaceCookTime;

    @Shadow
    public abstract ItemStack getInputItemStack();

    @Shadow
    public abstract boolean isFlooded();

    @Shadow
    public abstract boolean isSmotheredBySolidBlock();

    @Shadow
    protected abstract boolean canSmelt(int var1);

    @Shadow
    public abstract int getFuelHeatLevel();

    @Shadow
    public abstract int getItemBurnTime(ItemStack var1);

    @Shadow
    public abstract int getItemHeatLevel(ItemStack var1);

    @Shadow
    public abstract boolean isBurning();

    @Shadow
    public abstract void smeltItem(int var1);

    @ModifyConstant(method={"smeltItem"}, constant={@Constant(intValue=1)})
    private int modifyConsumption(int constant) {
        return Handlers.Smelting.match(this.getInputItemStack(), this.heat_level).map(SmeltingHandler.SmeltingResult::consumption).orElse(constant);
    }

    @Overwrite
    public int getCookProgressScaled(int par1) {
        return this.furnaceCookTime * par1 / Handlers.FurnaceUpdate.onFurnaceCookTimeTargetModify((TileEntityFurnace)this, 200);
    }

    @Overwrite
    public void updateEntity() {
        Handlers.FurnaceUpdate.onFurnaceUpdatePre((TileEntityFurnace)this);
        if (this.worldObj.isRemote || this.furnaceBurnTime == 1 || !this.isFlooded() && !this.isSmotheredBySolidBlock()) {
            boolean var1 = this.furnaceBurnTime > 0;
            boolean var2 = false;
            if (this.furnaceBurnTime > 0) {
                this.furnaceBurnTime -= Handlers.FurnaceUpdate.onFurnaceBurnTimeDecreaseModify((TileEntityFurnace)this, 1);
            } else {
                this.heat_level = 0;
            }
            if (!this.worldObj.isRemote) {
                if (this.furnaceBurnTime == 0 && this.canSmelt(this.getFuelHeatLevel()) && Handlers.FurnaceUpdate.onFurnaceBeginToBurn((TileEntityFurnace)this, true)) {
                    this.currentItemBurnTime = this.furnaceBurnTime = this.getItemBurnTime(this.furnaceItemStacks[1]);
                    if (this.furnaceBurnTime > 0) {
                        this.heat_level = this.getItemHeatLevel(this.furnaceItemStacks[1]);
                        var2 = true;
                        if (this.furnaceItemStacks[1] != null) {
                            --this.furnaceItemStacks[1].stackSize;
                            if (this.furnaceItemStacks[1].stackSize == 0) {
                                Item var3 = this.furnaceItemStacks[1].getItem().getContainerItem();
                                this.furnaceItemStacks[1] = var3 != null ? new ItemStack(var3) : null;
                            }
                            Handlers.FurnaceUpdate.onFurnaceFuelConsumed((TileEntityFurnace)this);
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt(this.heat_level)) {
                    Handlers.FurnaceUpdate.onFurnaceCookTimeAdd((TileEntityFurnace)this);
                    this.furnaceCookTime += Handlers.FurnaceUpdate.onFurnaceCookTimeIncreaseModify((TileEntityFurnace)this, 1);
                    if (this.furnaceCookTime >= Handlers.FurnaceUpdate.onFurnaceCookTimeTargetModify((TileEntityFurnace)this, 200)) {
                        this.furnaceCookTime = 0;
                        this.smeltItem(this.heat_level);
                        Handlers.FurnaceUpdate.onFurnaceCookSuccess((TileEntityFurnace)this);
                        var2 = true;
                    }
                } else {
                    this.furnaceCookTime = 0;
                }
                if (var1 != this.furnaceBurnTime > 0) {
                    var2 = true;
                    BlockFurnace.updateFurnaceBlockState((this.furnaceBurnTime > 0 ? 1 : 0) != 0, (World)this.worldObj, (int)this.xCoord, (int)this.yCoord, (int)this.zCoord);
                }
            }
            if (var2) {
                this.onInventoryChanged();
            }
        } else {
            if (this.furnaceBurnTime > 0) {
                if (this.isFlooded()) {
                    this.worldObj.blockFX(EnumBlockFX.steam, this.xCoord, this.yCoord, this.zCoord);
                }
                BlockFurnace.updateFurnaceBlockState((boolean)false, (World)this.worldObj, (int)this.xCoord, (int)this.yCoord, (int)this.zCoord);
            }
            this.furnaceBurnTime = 0;
            this.furnaceCookTime = 0;
        }
    }

    @Inject(method={"getHeatLevelRequired"}, at={@At(value="HEAD")}, cancellable=true)
    private static void injectHeatLevel(int item_id, CallbackInfoReturnable<Integer> cir) {
        Item item = Item.getItem((int)item_id);
        IFusibleItem.cast(item).ifPresent(x -> cir.setReturnValue((Object)x.getHeatLevelRequired()));
        if (MinecraftRegistry.instance != null && MinecraftRegistry.instance.itemHeatLevelMap.containsKey(item_id)) {
            cir.setReturnValue((Object)MinecraftRegistry.instance.itemHeatLevelMap.get(item_id));
            return;
        }
        ItemProperties.HeatLevelRequired.getOptional(item).ifPresent(arg_0 -> cir.setReturnValue(arg_0));
    }
}

