/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.mixin.server;

import moddedmite.rustedironcore.api.event.Handlers;
import moddedmite.rustedironcore.api.event.events.PlayerLoggedInEvent;
import moddedmite.rustedironcore.api.event.events.PlayerLoggedOutEvent;
import moddedmite.rustedironcore.api.player.PlayerAPI;
import net.minecraft.ServerPlayer;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin {
    @Inject(method={"playerLoggedIn"}, at={@At(value="RETURN")})
    private void onPlayerLoggedIn(ServerPlayer player, CallbackInfo ci) {
        boolean firstLogin = ((PlayerAPI)player).ric$IsFirstLogin();
        Handlers.PlayerEvent.onPlayerLoggedIn(new PlayerLoggedInEvent(player, firstLogin));
        if (firstLogin) {
            ((PlayerAPI)player).ric$SetFirstLogin(false);
        }
    }

    @Inject(method={"playerLoggedOut"}, at={@At(value="RETURN")})
    private void onPlayerLoggedOut(ServerPlayer player, CallbackInfo ci) {
        Handlers.PlayerEvent.onPlayerLoggedOut(new PlayerLoggedOutEvent(player));
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void onTick(CallbackInfo ci) {
        Handlers.Tick.onServerTick(MinecraftServer.getServer());
    }
}

