/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.mixin.item;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import huix.glacier.api.extension.material.IBucketMaterial;
import moddedmite.rustedironcore.api.util.VesselUtil;
import moddedmite.rustedironcore.property.MaterialProperties;
import net.minecraft.ItemBucket;
import net.minecraft.ItemVessel;
import net.minecraft.Material;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemBucket.class})
public abstract class ItemBucketMixin
extends ItemVessel {
    public ItemBucketMixin(int id, Material vessel_material, Material contents_material, int standard_volume, int max_stack_size_empty, int max_stack_size_full, String texture) {
        super(id, vessel_material, contents_material, standard_volume, max_stack_size_empty, max_stack_size_full, texture);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void register(int id, Material material, Material contents, CallbackInfo ci) {
        VesselUtil.registerBucket(material, contents, (ItemVessel)((ItemBucket)this));
    }

    @ModifyExpressionValue(method={"onItemRightClick"}, at={@At(value="INVOKE", target="Lnet/minecraft/ItemBucket;getPeerForContents(Lnet/minecraft/Material;)Lnet/minecraft/ItemVessel;")})
    private ItemVessel fixNPE(ItemVessel original) {
        if (original == null) {
            return this;
        }
        return original;
    }

    @Inject(method={"getPeer"}, at={@At(value="HEAD")}, cancellable=true)
    private static void makeSafe(Material vessel_material, Material contents, CallbackInfoReturnable<ItemVessel> cir) {
        VesselUtil.getBucket(vessel_material, contents).ifPresent(arg_0 -> cir.setReturnValue(arg_0));
    }

    @Inject(method={"getChanceOfMeltingWhenFilledWithLava"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyChance(CallbackInfoReturnable<Float> cir) {
        Material vesselMaterial = this.getVesselMaterial();
        if (vesselMaterial instanceof IBucketMaterial) {
            IBucketMaterial iBucketMaterial = (IBucketMaterial)vesselMaterial;
            cir.setReturnValue((Object)Float.valueOf(iBucketMaterial.getMeltingChance()));
            return;
        }
        MaterialProperties.BucketMeltingChance.getOptional(vesselMaterial).ifPresent(arg_0 -> cir.setReturnValue(arg_0));
    }
}

