/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.mixin.entity.player;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import moddedmite.rustedironcore.api.event.Handlers;
import moddedmite.rustedironcore.api.player.PlayerAPI;
import net.minecraft.Block;
import net.minecraft.Damage;
import net.minecraft.Entity;
import net.minecraft.EntityDamageResult;
import net.minecraft.EntityLivingBase;
import net.minecraft.EntityPlayer;
import net.minecraft.EnumEntityReachContext;
import net.minecraft.Item;
import net.minecraft.NBTTagCompound;
import net.minecraft.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityPlayer.class})
public abstract class EntityPlayerMixin
extends EntityLivingBase
implements PlayerAPI {
    @Unique
    private boolean firstLogin = true;

    public EntityPlayerMixin(World par1World) {
        super(par1World);
    }

    @Inject(method={"onLivingUpdate()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/EntityLivingBase;onLivingUpdate()V", shift=At.Shift.AFTER)})
    private void injectTick(CallbackInfo ci) {
        Handlers.Tick.onEntityPlayerTick((EntityPlayer)this);
    }

    @Inject(method={"writeEntityToNBT"}, at={@At(value="RETURN")})
    private void write(NBTTagCompound par1NBTTagCompound, CallbackInfo ci) {
        par1NBTTagCompound.setBoolean("FirstLogin", this.firstLogin);
    }

    @Inject(method={"readEntityFromNBT"}, at={@At(value="RETURN")})
    private void read(NBTTagCompound par1NBTTagCompound, CallbackInfo ci) {
        this.firstLogin = par1NBTTagCompound.getBoolean("FirstLogin");
    }

    @Inject(method={"clonePlayer"}, at={@At(value="RETURN")})
    private void onClone(EntityPlayer par1EntityPlayer, boolean par2, CallbackInfo ci) {
        this.firstLogin = ((PlayerAPI)par1EntityPlayer).ric$IsFirstLogin();
    }

    @Override
    public boolean ric$IsFirstLogin() {
        return this.firstLogin;
    }

    @Override
    public void ric$SetFirstLogin(boolean firstLogin) {
        this.firstLogin = firstLogin;
    }

    @Inject(method={"attackEntityFrom"}, at={@At(value="INVOKE", target="Lnet/minecraft/Damage;isExplosion()Z")})
    private void onPlayerReceiveDamageModify(Damage damage, CallbackInfoReturnable<EntityDamageResult> cir) {
        Handlers.Combat.onPlayerReceiveDamageModify((EntityPlayer)this, damage);
    }

    @ModifyReturnValue(method={"calcRawMeleeDamageVs(Lnet/minecraft/Entity;ZZ)F"}, at={@At(value="RETURN", ordinal=1)})
    private float onPlayerRawMeleeDamageModify(float original, @Local(argsOnly=true) Entity target, @Local(argsOnly=true, ordinal=0) boolean critical, @Local(argsOnly=true, ordinal=1) boolean suspended_in_liquid) {
        return Handlers.Combat.onPlayerRawMeleeDamageModify((EntityPlayer)this, target, critical, suspended_in_liquid, original);
    }

    @ModifyReturnValue(method={"getReach(Lnet/minecraft/Block;I)F"}, at={@At(value="RETURN")})
    private float modifyReach(float original, @Local(argsOnly=true) Block block, @Local(argsOnly=true) int metadata) {
        return Handlers.Combat.onPlayerBlockReachModify((EntityPlayer)this, block, metadata, original);
    }

    @ModifyReturnValue(method={"getReach(Lnet/minecraft/EnumEntityReachContext;Lnet/minecraft/Entity;)F"}, at={@At(value="RETURN")})
    private float modifyReach(float original, @Local(argsOnly=true) EnumEntityReachContext context, @Local(argsOnly=true) Entity entity) {
        return Handlers.Combat.onPlayerEntityReachModify((EntityPlayer)this, context, entity, original);
    }

    @ModifyExpressionValue(method={"getCurrentPlayerStrVsBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/Item;getStrVsBlock(Lnet/minecraft/Block;I)F")})
    private float modifyRawStrVsBlock(float original, @Local Block block, @Local(ordinal=3) int metadata, @Local Item held_item) {
        return Handlers.Combat.onPlayerRawStrVsBlockModify((EntityPlayer)this, held_item, block, metadata, original);
    }

    @ModifyArg(method={"getCurrentPlayerStrVsBlock"}, at=@At(value="INVOKE", target="Ljava/lang/Math;max(FF)F"), index=0)
    private float modifyStrVsBlock(float str_vs_block) {
        return Handlers.Combat.onPlayerStrVsBlockModify((EntityPlayer)this, str_vs_block);
    }

    public boolean knockBack(Entity attacker, float amount) {
        amount = Handlers.Combat.onPlayerReceiveKnockBackModify((EntityPlayer)this, attacker, amount);
        return super.knockBack(attacker, amount);
    }

    @ModifyReturnValue(method={"getHealthLimit()F"}, at={@At(value="RETURN")})
    private float modifyHealthLimit(float original) {
        return Handlers.PlayerAttribute.onHealthLimitModify((EntityPlayer)this, original);
    }

    @ModifyReturnValue(method={"getHighestPossibleLevel"}, at={@At(value="RETURN")})
    private static int modifyMaxLevel(int original) {
        return Handlers.PlayerAttribute.onLevelLimitModify(original);
    }

    @ModifyConstant(method={"getExperienceLevel(I)I"}, constant={@Constant(intValue=-40)})
    private int modifyMinLevel(int original) {
        return Handlers.PlayerAttribute.onLevelMinLimitModify(original);
    }

    @ModifyConstant(method={"addExperience(IZZ)V"}, constant={@Constant(intValue=-40)})
    private int modifyMinLevel_1(int original) {
        return Handlers.PlayerAttribute.onLevelMinLimitModify(original);
    }
}

