/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.mixin.entity;

import huix.glacier.api.extension.material.IBowMaterial;
import moddedmite.rustedironcore.api.item.BowItem;
import net.minecraft.Entity;
import net.minecraft.EntityArrow;
import net.minecraft.EntityPlayer;
import net.minecraft.Item;
import net.minecraft.ItemBow;
import net.minecraft.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={EntityArrow.class})
public abstract class EntityArrowMixin {
    @Shadow
    public Entity shootingEntity;

    @Shadow
    public abstract ItemStack getLauncher();

    @ModifyVariable(method={"setThrowableHeading"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float modifySpeed(float velocity) {
        Item item;
        ItemBow itemBow;
        ItemStack launcher = this.getLauncher();
        if (launcher == null) {
            return velocity;
        }
        Item item2 = launcher.getItem();
        if (item2 instanceof ItemBow && (item2 = (itemBow = (ItemBow)item2).getMaterialForRepairs()) instanceof IBowMaterial) {
            IBowMaterial iBowMaterial = (IBowMaterial)item2;
            if (this.shootingEntity instanceof EntityPlayer) {
                velocity *= 1.0f + (float)iBowMaterial.velocityBonus() / 100.0f;
            }
        }
        if ((item = launcher.getItem()) instanceof BowItem) {
            BowItem bowItem = (BowItem)item;
            velocity *= 1.0f + (float)bowItem.velocityBonus() / 100.0f;
        }
        return velocity;
    }
}

