/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.mixin.container;

import moddedmite.rustedironcore.internal.network.packets.S2CSyncTradeRecipe;
import moddedmite.rustedironcore.network.Network;
import net.minecraft.Container;
import net.minecraft.ContainerMerchant;
import net.minecraft.EntityPlayer;
import net.minecraft.IMerchant;
import net.minecraft.ItemStack;
import net.minecraft.ServerPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ContainerMerchant.class})
public abstract class ContainerMerchantMixin
extends Container {
    @Shadow
    private IMerchant theMerchant;

    @Shadow
    public abstract void detectAndSendChanges();

    public ContainerMerchantMixin(EntityPlayer player) {
        super(player);
    }

    @Inject(method={"transferStackInSlot"}, at={@At(value="RETURN")})
    private void sync(EntityPlayer par1EntityPlayer, int par2, CallbackInfoReturnable<ItemStack> cir) {
        if (this.player.onServer()) {
            ServerPlayer player = (ServerPlayer)this.player;
            player.sendContainerToPlayer((Container)this);
            Network.sendToClient(player, new S2CSyncTradeRecipe(player.currentWindowId, this.theMerchant.getRecipes((EntityPlayer)player)));
        }
    }

    @Inject(method={"onContainerClosed"}, at={@At(value="RETURN")})
    private void sync(EntityPlayer par1EntityPlayer, CallbackInfo ci) {
        if (this.player.onServer()) {
            ((ServerPlayer)this.player).sendContainerToPlayer((Container)this);
        }
    }
}

