/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.mixin.block;

import java.util.Random;
import moddedmite.rustedironcore.api.event.Handlers;
import net.minecraft.AchievementList;
import net.minecraft.BlockBreakInfo;
import net.minecraft.BlockConstants;
import net.minecraft.BlockFalling;
import net.minecraft.BlockGravel;
import net.minecraft.DedicatedServer;
import net.minecraft.EntityPlayer;
import net.minecraft.Item;
import net.minecraft.Material;
import net.minecraft.StatBase;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BlockGravel.class})
public abstract class BlockGravelMixin
extends BlockFalling {
    @Shadow
    public abstract boolean isNetherGravel(int var1);

    public BlockGravelMixin(int par1, Material material, BlockConstants constants) {
        super(par1, material, constants);
    }

    @Overwrite
    public int dropBlockAsEntityItem(BlockBreakInfo info) {
        int id_dropped;
        if (info.getMetadata() == 1) {
            return super.dropBlockAsEntityItem(info);
        }
        if (info.wasExploded() || !info.wasHarvestedByPlayer()) {
            return super.dropBlockAsEntityItem(info);
        }
        int fortune = info.getHarvesterFortune();
        if (fortune > 3) {
            fortune = 3;
        }
        Random rand = info.world.rand;
        float dropAsGravelChance = Handlers.GravelDrop.onDropAsGravelChanceModify(info, 1.0f - 3.0f / (float)(12 - 2 * fortune));
        if (rand.nextFloat() < dropAsGravelChance) {
            return super.dropBlockAsEntityItem(info);
        }
        float dropAsFlintChance = Handlers.GravelDrop.onDropAsFlintChanceModify(info, 0.6666667f);
        if (rand.nextFloat() < dropAsFlintChance) {
            float dropFlintAsChipChance = Handlers.GravelDrop.onDropFlintAsChipChanceModify(info, 0.9375f);
            if (rand.nextFloat() < dropFlintAsChipChance) {
                if (info.wasExploded()) {
                    return super.dropBlockAsEntityItem(info);
                }
                id_dropped = Item.chipFlint.itemID;
            } else {
                id_dropped = info.wasExploded() ? Item.chipFlint.itemID : Item.flint.itemID;
            }
        } else {
            id_dropped = Handlers.GravelDrop.getRandomDropID(info, rand);
        }
        if (this.isNetherGravel(info.getMetadata())) {
            id_dropped = Handlers.GravelDrop.onNetherGravelDropIDModify(info, id_dropped);
        }
        if (id_dropped != -1) {
            DedicatedServer.incrementTournamentScoringCounter((EntityPlayer)info.getResponsiblePlayer(), (Item)Item.getItem((int)id_dropped));
        }
        if (info.wasHarvestedByPlayer() && (id_dropped == Item.chipFlint.itemID || id_dropped == Item.flint.itemID)) {
            info.getResponsiblePlayer().triggerAchievement((StatBase)AchievementList.flintFinder);
        }
        Handlers.GravelDrop.onDropResult(info, id_dropped);
        return this.dropBlockAsEntityItem(info, id_dropped);
    }
}

