/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.internal.event.listeners;

import moddedmite.rustedironcore.api.event.events.PlayerLoggedInEvent;
import moddedmite.rustedironcore.api.event.listener.IPlayerEventListener;
import moddedmite.rustedironcore.api.util.FabricUtil;
import moddedmite.rustedironcore.internal.config.RICConfig;
import moddedmite.rustedironcore.internal.network.packets.S2COpenGuiTips;
import moddedmite.rustedironcore.internal.network.packets.S2CSyncNutritionLimit;
import moddedmite.rustedironcore.network.Network;
import net.minecraft.ServerPlayer;
import net.minecraft.server.MinecraftServer;

public class PlayerEventListener
implements IPlayerEventListener {
    @Override
    public void onPlayerLoggedIn(PlayerLoggedInEvent event) {
        ServerPlayer player = event.player();
        Network.sendToClient(player, new S2CSyncNutritionLimit(player.ric$GetNutritionLimit()));
        if (this.shouldState(event.firstLogin())) {
            player.addChatMessage("ric.statement");
            Network.sendToClient(player, new S2COpenGuiTips());
        }
    }

    private boolean shouldState(boolean firstLogin) {
        if (!firstLogin) {
            return false;
        }
        if (FabricUtil.isDevelopmentEnvironment()) {
            return false;
        }
        if (((Boolean)RICConfig.StatementOnLogin.get()).booleanValue()) {
            return true;
        }
        return !MinecraftServer.getServer().isServerInOnlineMode();
    }
}

