/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.internal.delegate.world.biome;

import java.util.ArrayList;
import java.util.List;
import moddedmite.rustedironcore.api.event.Handlers;
import net.minecraft.BiomeGenBase;
import net.minecraft.GenLayer;
import net.minecraft.GenLayerFuzzyZoom;
import net.minecraft.GenLayerIsland;
import net.minecraft.GenLayerVoronoiZoom;
import net.minecraft.GenLayerZoom;
import net.minecraft.IntCache;

public class GenLayerUnderbiome
extends GenLayer {
    private final List<BiomeGenBase> biomes;

    public GenLayerUnderbiome(long seed, GenLayer layer) {
        super(seed);
        this.parent = layer;
        this.biomes = new ArrayList<BiomeGenBase>();
        this.biomes.add(BiomeGenBase.underworld);
        Handlers.BiomeGenerate.onUnderworldBiomesRegister(this.biomes);
    }

    public static GenLayer[] initializeAllBiomeGenerators(long seed) {
        Object obj = new GenLayerIsland(1L);
        obj = new GenLayerFuzzyZoom(2000L, (GenLayer)obj);
        for (int i = 1; i < 3; ++i) {
            obj = new GenLayerFuzzyZoom(2000L + (long)i, (GenLayer)obj);
        }
        obj = GenLayerZoom.magnify((long)1000L, (GenLayer)obj, (int)0);
        obj = new GenLayerUnderbiome(200L, (GenLayer)obj);
        obj = GenLayerZoom.magnify((long)1000L, (GenLayer)obj, (int)2);
        int biomesize = 3;
        for (int j = 0; j < biomesize; ++j) {
            obj = new GenLayerZoom(1000L + (long)j, (GenLayer)obj);
        }
        GenLayerVoronoiZoom genlayervoronoizoom = new GenLayerVoronoiZoom(10L, (GenLayer)obj);
        obj.initWorldGenSeed(seed);
        genlayervoronoizoom.initWorldGenSeed(seed);
        return new GenLayer[]{obj, genlayervoronoizoom};
    }

    public int[] getInts(int i, int j, int k, int l, int m) {
        int[] ints = IntCache.getIntCache((int)(k * l));
        for (int x = 0; x < l; ++x) {
            for (int z = 0; z < k; ++z) {
                this.initChunkSeed(z + i, x + j);
                ints[z + x * k] = this.biomes.get((int)this.nextInt((int)this.biomes.size())).biomeID;
            }
        }
        return ints;
    }
}

