/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.api.world;

import java.util.Random;
import net.minecraft.World;
import net.minecraft.WorldGenMinable;

public class MinableWorldGen
extends WorldGenMinable {
    VeinHeightSupplier maxVeinHeight;
    VeinHeightSupplier minVeinHeight;
    RandomVeinHeightSupplier randomVeinHeight;
    public static final VeinHeightSupplier BOTTOM_HEIGHT = (world, minable) -> 0;
    public static final VeinHeightSupplier ROOF_HEIGHT = (world, minable) -> 255;
    public static final RandomVeinHeightSupplier STANDARD_RANDOM_HEIGHT;
    @Deprecated
    public static final RandomVeinHeightSupplier Common;

    public MinableWorldGen(int minableBlockId, int numberOfBlocks) {
        super(minableBlockId, numberOfBlocks);
    }

    public MinableWorldGen(int minableBlockId, int numberOfBlocks, int blockToReplace) {
        super(minableBlockId, numberOfBlocks, blockToReplace);
    }

    public MinableWorldGen setMaxVeinHeight(VeinHeightSupplier maxVeinHeight) {
        this.maxVeinHeight = maxVeinHeight;
        return this;
    }

    public int getMaxVeinHeight(World world) {
        return this.maxVeinHeight.getVeinHeight(world, this);
    }

    public MinableWorldGen setMinVeinHeight(VeinHeightSupplier minVeinHeight) {
        this.minVeinHeight = minVeinHeight;
        return this;
    }

    public int getMinVeinHeight(World world) {
        return this.minVeinHeight.getVeinHeight(world, this);
    }

    public MinableWorldGen setRandomVeinHeight(RandomVeinHeightSupplier randomVeinHeight) {
        this.randomVeinHeight = randomVeinHeight;
        return this;
    }

    public int getRandomVeinHeight(World world, Random rand) {
        return this.randomVeinHeight.getVeinHeight(world, rand, this);
    }

    static {
        Common = STANDARD_RANDOM_HEIGHT = (world, rand, minable) -> {
            float relative_height;
            while ((relative_height = rand.nextFloat()) >= rand.nextFloat()) {
            }
            int min_height = minable.getMinVeinHeight(world);
            int height_range = minable.getMaxVeinHeight(world) - min_height + 1;
            return min_height + (int)(relative_height * (float)height_range);
        };
    }

    @FunctionalInterface
    public static interface VeinHeightSupplier {
        public int getVeinHeight(World var1, MinableWorldGen var2);
    }

    @FunctionalInterface
    public static interface RandomVeinHeightSupplier {
        public int getVeinHeight(World var1, Random var2, MinableWorldGen var3);
    }
}

