/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.api.world;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.World;

public record Dimension(String name, int id) {
    private static final Map<String, Dimension> STRING_TO_DIMENSION = new HashMap<String, Dimension>(4);
    private static final Map<Integer, Dimension> ID_TO_DIMENSION = new HashMap<Integer, Dimension>(4);
    public static final Dimension OVERWORLD = Dimension.register("overworld", 0);
    public static final Dimension NETHER = Dimension.register("the_nether", -1);
    public static final Dimension END = Dimension.register("the_end", 1);
    public static final Dimension UNDERWORLD = Dimension.register("the_end", -2);

    public static Dimension register(String name, int id) {
        return Dimension.register(new Dimension(name, id));
    }

    public static Dimension register(Dimension dimension) {
        String name = dimension.name();
        int id = dimension.id();
        STRING_TO_DIMENSION.put(name, dimension);
        ID_TO_DIMENSION.put(id, dimension);
        return dimension;
    }

    @Nullable
    public static Dimension fromString(String name) {
        return STRING_TO_DIMENSION.get(name);
    }

    @Nullable
    public static Dimension fromId(int id) {
        return ID_TO_DIMENSION.get(id);
    }

    public boolean isOf(World world) {
        return world.getDimensionId() == this.id;
    }

    public static Stream<Dimension> streamDimensions() {
        return STRING_TO_DIMENSION.values().stream();
    }

    @Override
    public String toString() {
        return this.name;
    }
}

