/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.api.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ItemBowl;
import net.minecraft.ItemVessel;
import net.minecraft.Material;

public class VesselUtil {
    private static final Table<Material, Material, ItemVessel> BucketTable = HashBasedTable.create();
    private static final Map<Material, ItemVessel> EmptyBucketMap = new HashMap<Material, ItemVessel>();
    private static final Table<Material, Material, ItemBowl> BowlTable = HashBasedTable.create();
    private static final Map<Material, ItemBowl> EmptyBowlMap = new HashMap<Material, ItemBowl>();

    public static Optional<ItemVessel> getBucket(Material vessel_material, Material contents) {
        if (contents == null) {
            return Optional.ofNullable(EmptyBucketMap.get(vessel_material));
        }
        return Optional.ofNullable((ItemVessel)BucketTable.get((Object)vessel_material, (Object)contents));
    }

    public static void registerBucket(Material vessel_material, Material contents, ItemVessel itemBucket) {
        if (contents == null) {
            EmptyBucketMap.put(vessel_material, itemBucket);
        } else {
            BucketTable.put((Object)vessel_material, (Object)contents, (Object)itemBucket);
        }
    }

    public static Optional<ItemBowl> getBowl(Material vessel_material, Material contents) {
        if (contents == null) {
            return Optional.ofNullable(EmptyBowlMap.get(vessel_material));
        }
        return Optional.ofNullable((ItemBowl)BowlTable.get((Object)vessel_material, (Object)contents));
    }

    public static void registerBowl(ItemBowl itemBowl) {
        VesselUtil.registerBowl(itemBowl.getVesselMaterial(), itemBowl.getContents(), itemBowl);
    }

    public static void registerBowl(Material vessel_material, Material contents, ItemBowl itemBowl) {
        if (contents == null) {
            EmptyBowlMap.put(vessel_material, itemBowl);
        } else {
            BowlTable.put((Object)vessel_material, (Object)contents, (Object)itemBowl);
        }
    }
}

