/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.api.util;

import java.nio.file.Path;
import java.util.Optional;
import moddedmite.rustedironcore.api.util.LogUtil;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.impl.util.version.SemanticVersionImpl;
import net.xiaoyu233.fml.FishModLoader;
import org.apache.logging.log4j.Logger;

public class FabricUtil {
    private static final Logger LOGGER = LogUtil.getLogger();
    private static final Path GAME_DIR = Path.of("", new String[0]);

    public static Optional<ModContainer> getModContainer(String modid) {
        return FishModLoader.getModContainer((String)modid);
    }

    public static Optional<ModMetadata> getModMetadata(String modid) {
        return FabricUtil.getModContainer(modid).map(ModContainer::getMetadata);
    }

    public static Optional<Version> getModVersion(String modid) {
        return FabricUtil.getModMetadata(modid).map(ModMetadata::getVersion);
    }

    public static int compareModVersion(String modid, String version) {
        Optional<Version> modVersion = FabricUtil.getModVersion(modid);
        if (modVersion.isEmpty()) {
            return -2;
        }
        Version presentVersion = modVersion.get();
        try {
            SemanticVersionImpl compareTo = new SemanticVersionImpl(version, false);
            return presentVersion.compareTo((Object)compareTo);
        }
        catch (VersionParsingException e) {
            LOGGER.warn("invalid semantic version {}", (Object)version);
            e.printStackTrace();
            return -3;
        }
    }

    public static boolean isModLoaded(String modid) {
        return FishModLoader.hasMod((String)modid);
    }

    public static boolean isServer() {
        return FishModLoader.isServer();
    }

    public static Path getGameDirectory() {
        return GAME_DIR;
    }

    public static Path getModsDirectory() {
        return GAME_DIR.resolve("mods");
    }

    public static Path getConfigDirectory() {
        return GAME_DIR.resolve("config");
    }

    public static boolean isDevelopmentEnvironment() {
        return FishModLoader.isDevelopmentEnvironment();
    }
}

