/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.api.event.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import moddedmite.rustedironcore.api.event.EventHandler;
import moddedmite.rustedironcore.api.event.events.TradingRegisterEvent;
import moddedmite.rustedironcore.api.util.LogUtil;
import moddedmite.rustedironcore.random.RandomUtil;
import moddedmite.rustedironcore.villager.VillagerSettings;
import net.minecraft.Block;
import net.minecraft.Enchantment;
import net.minecraft.EnchantmentData;
import net.minecraft.EnchantmentHelper;
import net.minecraft.EntityVillager;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.minecraft.MathHelper;
import net.minecraft.MerchantRecipe;
import net.minecraft.MerchantRecipeList;
import org.apache.logging.log4j.Logger;

public class TradingHandler
extends EventHandler<TradingRegisterEvent> {
    private static final Logger LOGGER = LogUtil.getLogger();
    private final Map<Integer, VillagerSettings> professionMap = new HashMap<Integer, VillagerSettings>();
    public static final VillagerSettings Farmer = new VillagerSettings(0, "villager.profession.farmer", VillagerSettings.FarmerTexture);
    public static final VillagerSettings Librarian = new VillagerSettings(1, "villager.profession.librarian", VillagerSettings.LibrarianTexture);
    public static final VillagerSettings Priest = new VillagerSettings(2, "villager.profession.priest", VillagerSettings.PriestTexture);
    public static final VillagerSettings Smith = new VillagerSettings(3, "villager.profession.smith", VillagerSettings.SmithTexture);
    public static final VillagerSettings Butcher = new VillagerSettings(4, "villager.profession.butcher", VillagerSettings.ButcherTexture);
    public static final Consumer<TradingRegisterEvent> VanillaListener = event -> {
        event.registerProfession(0, Farmer);
        event.registerProfession(1, Librarian);
        event.registerProfession(2, Priest);
        event.registerProfession(3, Smith);
        event.registerProfession(4, Butcher);
        Farmer.buyEntry(Item.wheat.itemID, 0.9f);
        Farmer.buyEntry(Block.cloth.blockID, 0.5f);
        Farmer.buyEntry(Item.chickenRaw.itemID, 0.5f);
        Farmer.buyEntry(Item.fishCooked.itemID, 0.4f);
        Farmer.sellEntry(Item.bread.itemID, 0.9f);
        Farmer.sellEntry(Item.melon.itemID, 0.3f);
        Farmer.sellEntry(Item.appleRed.itemID, 0.3f);
        Farmer.sellEntry(Item.cookie.itemID, 0.3f);
        Farmer.sellEntry(Item.shears.itemID, 0.3f);
        Farmer.sellEntry(Item.flintAndSteel.itemID, 0.3f);
        Farmer.sellEntry(Item.chickenCooked.itemID, 0.3f);
        Farmer.sellEntry(Item.arrowFlint.itemID, 0.5f);
        Farmer.addEntry((recipeList, villager, rand) -> {
            if (rand.nextFloat() < villager.adjustProbability(0.5f)) {
                recipeList.add((Object)new MerchantRecipe(new ItemStack((Block)Block.gravel, 4), new ItemStack(Item.emerald), new ItemStack(Item.flint.itemID, 4 + rand.nextInt(2), 0)));
            }
        });
        Librarian.buyEntry(Item.paper.itemID, 0.8f);
        Librarian.buyEntry(Item.book.itemID, 0.8f);
        Librarian.buyEntry(Item.writtenBook.itemID, 0.3f);
        Librarian.sellEntry(Block.bookShelf.blockID, 0.8f);
        Librarian.sellEntry(Block.glass.blockID, 0.2f);
        Librarian.sellEntry(Item.compass.itemID, 0.2f);
        Librarian.sellEntry(Item.pocketSundial.itemID, 0.2f);
        Librarian.addEntry((recipeList, villager, rand) -> {
            if (rand.nextFloat() < villager.adjustProbability(0.07f)) {
                Enchantment var8 = Enchantment.enchantmentsBookList[rand.nextInt(Enchantment.enchantmentsBookList.length)];
                int var10 = MathHelper.getRandomIntegerInRange((Random)rand, (int)1, (int)var8.getNumLevels());
                ItemStack var11 = Item.enchantedBook.getEnchantedItemStack(new EnchantmentData(var8, var10));
                int var6 = 2 + rand.nextInt(5 + var10 * 10) + 3 * var10;
                recipeList.add((Object)new MerchantRecipe(new ItemStack(Item.book), new ItemStack(Item.emerald, var6), var11));
            }
        });
        Priest.sellEntry(Item.eyeOfEnder.itemID, 0.3f);
        Priest.sellEntry(Item.redstone.itemID, 0.4f);
        Priest.sellEntry(Block.glowStone.blockID, 0.3f);
        Priest.addEntry((recipeList, villager, rand) -> {
            int[] var3 = new int[]{Item.swordCopper.itemID, Item.swordIron.itemID, Item.plateCopper.itemID, Item.plateIron.itemID, Item.axeCopper.itemID, Item.axeIron.itemID, Item.pickaxeCopper.itemID, Item.pickaxeIron.itemID};
            int var5 = var3.length;
            int var6 = 0;
            while (var6 < var5) {
                int var7 = var3[var6];
                if (rand.nextFloat() < villager.adjustProbability(0.05f)) {
                    recipeList.add((Object)new MerchantRecipe(new ItemStack(var7, 1, 0), new ItemStack(Item.emerald, 2 + rand.nextInt(3), 0), EnchantmentHelper.addRandomEnchantment((Random)rand, (ItemStack)new ItemStack(var7, 1, 0), (int)(5 + rand.nextInt(15)))));
                }
                ++var6;
            }
            return;
        });
        Smith.buyEntry(Item.coal.itemID, 0.7f);
        Smith.buyEntry(Item.ingotIron.itemID, 0.5f);
        Smith.buyEntry(Item.ingotGold.itemID, 0.5f);
        Smith.sellEntry(Item.swordIron.itemID, 0.5f);
        Smith.sellEntry(Item.axeIron.itemID, 0.3f);
        Smith.sellEntry(Item.pickaxeIron.itemID, 0.5f);
        Smith.sellEntry(Item.shovelIron.itemID, 0.2f);
        Smith.sellEntry(Item.hoeIron.itemID, 0.2f);
        Smith.sellEntry(Item.helmetIron.itemID, 0.2f);
        Smith.sellEntry(Item.plateIron.itemID, 0.2f);
        Smith.sellEntry(Item.legsIron.itemID, 0.2f);
        Smith.sellEntry(Item.bootsIron.itemID, 0.2f);
        Smith.sellEntry(Item.pickaxeCopper.itemID, 0.5f);
        Smith.sellEntry(Item.shovelCopper.itemID, 0.2f);
        Smith.sellEntry(Item.axeCopper.itemID, 0.3f);
        Smith.sellEntry(Item.hoeCopper.itemID, 0.2f);
        Smith.sellEntry(Item.daggerCopper.itemID, 0.5f);
        Smith.sellEntry(Item.swordCopper.itemID, 0.5f);
        Smith.sellEntry(Item.daggerIron.itemID, 0.5f);
        Smith.sellEntry(Item.helmetCopper.itemID, 0.2f);
        Smith.sellEntry(Item.plateCopper.itemID, 0.2f);
        Smith.sellEntry(Item.legsCopper.itemID, 0.2f);
        Smith.sellEntry(Item.bootsCopper.itemID, 0.2f);
        Smith.sellEntry(Item.helmetChainCopper.itemID, 0.1f);
        Smith.sellEntry(Item.plateChainCopper.itemID, 0.1f);
        Smith.sellEntry(Item.legsChainCopper.itemID, 0.1f);
        Smith.sellEntry(Item.bootsChainCopper.itemID, 0.1f);
        Smith.sellEntry(Item.helmetChainIron.itemID, 0.1f);
        Smith.sellEntry(Item.plateChainIron.itemID, 0.1f);
        Smith.sellEntry(Item.legsChainIron.itemID, 0.1f);
        Smith.sellEntry(Item.bootsChainIron.itemID, 0.1f);
        Butcher.buyEntry(Item.coal.itemID, 0.7f);
        Butcher.buyEntry(Item.porkRaw.itemID, 0.5f);
        Butcher.buyEntry(Item.beefRaw.itemID, 0.5f);
        Butcher.buyEntry(Item.lambchopRaw.itemID, 0.5f);
        Butcher.sellEntry(Item.saddle.itemID, 0.1f);
        Butcher.sellEntry(Item.plateLeather.itemID, 0.3f);
        Butcher.sellEntry(Item.bootsLeather.itemID, 0.3f);
        Butcher.sellEntry(Item.helmetLeather.itemID, 0.3f);
        Butcher.sellEntry(Item.legsLeather.itemID, 0.3f);
        Butcher.sellEntry(Item.porkCooked.itemID, 0.3f);
        Butcher.sellEntry(Item.beefCooked.itemID, 0.3f);
        Butcher.sellEntry(Item.lambchopCooked.itemID, 0.3f);
    };

    public TradingHandler() {
        this.register(VanillaListener);
    }

    public int getRandomProfession(Random rand) {
        List<VillagerSettings> unbannedList = this.professionMap.values().stream().filter(x -> !x.isBanned()).toList();
        if (unbannedList.isEmpty()) {
            return 0;
        }
        return RandomUtil.getRandom(unbannedList, rand).getProfession();
    }

    public Optional<VillagerSettings> getForProfession(int profession) {
        return Optional.ofNullable(this.professionMap.getOrDefault(profession, null));
    }

    public void registerProfession(int profession, VillagerSettings villagerSettings) {
        this.professionMap.put(profession, villagerSettings);
    }

    public void addRecipeToList(MerchantRecipeList recipeList, EntityVillager villager, Random rand) {
        VillagerSettings villagerSettings = this.professionMap.get(villager.getProfession());
        if (villagerSettings == null) {
            LOGGER.warn("unhandled villager profession: '{}'", (Object)villager.getProfession());
        } else {
            villagerSettings.getRecipeEntries().forEach(x -> x.apply(recipeList, villager, rand));
        }
    }
}

