/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.api.event.handler;

import java.util.HashMap;
import java.util.Map;
import moddedmite.rustedironcore.api.event.EventHandler;
import moddedmite.rustedironcore.api.event.events.SpawnConditionRegisterEvent;
import net.minecraft.Entity;
import net.minecraft.World;

public class SpawnConditionHandler
extends EventHandler<SpawnConditionRegisterEvent> {
    private final Map<Class<? extends Entity>, SpawnCondition> ConditionMap = new HashMap<Class<? extends Entity>, SpawnCondition>();

    public boolean has(Class<?> clazz) {
        return this.ConditionMap.containsKey(clazz);
    }

    public SpawnCondition get(Class<?> clazz) {
        return this.ConditionMap.get(clazz);
    }

    public void addCondition(Class<? extends Entity> clazz, SpawnCondition predicate) {
        if (this.ConditionMap.containsKey(clazz)) {
            SpawnCondition condition = this.ConditionMap.get(clazz);
            SpawnCondition wrapped = SpawnConditionHandler.wrap(clazz, condition, predicate);
            this.ConditionMap.put(clazz, wrapped);
        } else {
            this.ConditionMap.put(clazz, predicate);
        }
    }

    private static SpawnCondition wrap(Class<? extends Entity> clazz, SpawnCondition first, SpawnCondition second) {
        return (world, x, y, z) -> {
            Class<? extends Entity> result = first.getResult(world, x, y, z);
            if (result == null) {
                return null;
            }
            if (result == clazz) {
                return second.getResult(world, x, y, z);
            }
            return result;
        };
    }

    @FunctionalInterface
    public static interface SpawnCondition {
        public Class<? extends Entity> getResult(World var1, int var2, int var3, int var4);
    }
}

