/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.api.event.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import moddedmite.rustedironcore.api.event.EventHandler;
import moddedmite.rustedironcore.api.event.events.SmeltingRecipeRegisterEvent;
import net.minecraft.ItemStack;

public class SmeltingHandler
extends EventHandler<SmeltingRecipeRegisterEvent> {
    private final List<SpecialRecipe> specialRecipes = new ArrayList<SpecialRecipe>();

    public void addSpecialRecipe(SpecialRecipe specialRecipe) {
        this.specialRecipes.add(specialRecipe);
    }

    public Optional<SmeltingResult> match(ItemStack input_item_stack, int heat_level) {
        return this.specialRecipes.stream().map(specialRecipe -> specialRecipe.getSmeltingResult(input_item_stack, heat_level)).filter(Objects::nonNull).filter(x -> x.result != null).findFirst();
    }

    public static SmeltingResult result(int consumption, ItemStack result) {
        return new SmeltingResult(consumption, result);
    }

    public static SmeltingResult result(ItemStack result) {
        return new SmeltingResult(1, result);
    }

    public record SmeltingResult(int consumption, ItemStack result) {
        public SmeltingResult(ItemStack result) {
            this(1, result);
        }
    }

    @FunctionalInterface
    public static interface SpecialRecipe {
        @Nullable
        public SmeltingResult getSmeltingResult(ItemStack var1, int var2);
    }
}

