/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.api.event.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import moddedmite.rustedironcore.api.event.AbstractHandler;
import moddedmite.rustedironcore.api.event.listener.IGravelDropListener;
import moddedmite.rustedironcore.random.FloatWeightedEntry;
import moddedmite.rustedironcore.random.RandomUtil;
import net.minecraft.BlockBreakInfo;
import net.minecraft.Item;
import net.minecraft.MathHelper;

public class GravelDropHandler
extends AbstractHandler<IGravelDropListener> {
    public static final IGravelDropListener VanillaListener = new IGravelDropListener(){

        @Override
        public int onNetherGravelDropIDModify(BlockBreakInfo info, int original) {
            if (original == Item.copperNugget.itemID || original == Item.silverNugget.itemID || original == Item.mithrilNugget.itemID || original == Item.adamantiumNugget.itemID) {
                return Item.goldNugget.itemID;
            }
            if (original == Item.shardObsidian.itemID || original == Item.shardEmerald.itemID || original == Item.shardDiamond.itemID) {
                return Item.shardNetherQuartz.itemID;
            }
            return original;
        }
    };
    private final List<GravelLootEntry> lootEntries = new ArrayList<GravelLootEntry>();
    public static final GravelLootEntry CopperEntry = new GravelLootEntry(0.6666667f, blockBreakInfo -> Item.copperNugget.itemID);
    public static final GravelLootEntry SilverEntry = new GravelLootEntry(0.22222222f, blockBreakInfo -> Item.silverNugget.itemID);
    public static final GravelLootEntry GoldEntry = new GravelLootEntry(0.074074075f, blockBreakInfo -> Item.goldNugget.itemID);
    public static final GravelLootEntry ObsidianEntry = new GravelLootEntry(0.024691358f, blockBreakInfo -> blockBreakInfo.wasExploded() ? -1 : Item.shardObsidian.itemID);
    public static final GravelLootEntry EmeraldEntry = new GravelLootEntry(0.008230452f, blockBreakInfo -> blockBreakInfo.wasExploded() ? -1 : Item.shardEmerald.itemID);
    public static final GravelLootEntry DiamondEntry = new GravelLootEntry(0.0027434842f, blockBreakInfo -> blockBreakInfo.wasExploded() ? -1 : Item.shardDiamond.itemID);
    public static final GravelLootEntry MithrilEntry = new GravelLootEntry(9.1449474E-4f, blockBreakInfo -> Item.mithrilNugget.itemID);
    public static final GravelLootEntry AdamantiumEntry = new GravelLootEntry(4.5724737E-4f, blockBreakInfo -> Item.adamantiumNugget.itemID);

    public GravelDropHandler() {
        this.register(VanillaListener);
        this.registerGravelLootEntry(CopperEntry);
        this.registerGravelLootEntry(SilverEntry);
        this.registerGravelLootEntry(GoldEntry);
        this.registerGravelLootEntry(ObsidianEntry);
        this.registerGravelLootEntry(EmeraldEntry);
        this.registerGravelLootEntry(DiamondEntry);
        this.registerGravelLootEntry(MithrilEntry);
        this.registerGravelLootEntry(AdamantiumEntry);
    }

    public int onNetherGravelDropIDModify(BlockBreakInfo info, int original) {
        for (IGravelDropListener listener : this.listeners) {
            original = listener.onNetherGravelDropIDModify(info, original);
        }
        return original;
    }

    public void onDropResult(BlockBreakInfo info, int id_dropped) {
        this.listeners.forEach(x -> x.onDropResult(info, id_dropped));
    }

    public float onDropAsGravelChanceModify(BlockBreakInfo info, float original) {
        for (IGravelDropListener listener : this.listeners) {
            original = listener.onDropAsGravelChanceModify(info, original);
        }
        return MathHelper.clamp_float((float)original, (float)0.0f, (float)1.0f);
    }

    public float onDropAsFlintChanceModify(BlockBreakInfo info, float original) {
        for (IGravelDropListener listener : this.listeners) {
            original = listener.onDropAsFlintChanceModify(info, original);
        }
        return MathHelper.clamp_float((float)original, (float)0.0f, (float)1.0f);
    }

    public float onDropFlintAsChipChanceModify(BlockBreakInfo info, float original) {
        for (IGravelDropListener listener : this.listeners) {
            original = listener.onDropFlintAsChipChanceModify(info, original);
        }
        return MathHelper.clamp_float((float)original, (float)0.0f, (float)1.0f);
    }

    public void registerGravelLootEntry(GravelLootEntry gravelLootEntry) {
        this.lootEntries.add(gravelLootEntry);
    }

    public void unregisterGravelLootEntry(GravelLootEntry gravelLootEntry) {
        this.lootEntries.remove(gravelLootEntry);
    }

    public int getRandomDropID(BlockBreakInfo info, Random random) {
        GravelLootEntry randomEntry = RandomUtil.getRandomEntryFloat(this.lootEntries, random);
        if (randomEntry != null) {
            return randomEntry.dropFunc.apply(info);
        }
        return -1;
    }

    public record GravelLootEntry(float weight, Function<BlockBreakInfo, Integer> dropFunc) implements FloatWeightedEntry
    {
        @Override
        public float getWeight() {
            return this.weight;
        }
    }
}

