/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.api.event.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import moddedmite.rustedironcore.api.event.EventHandler;
import moddedmite.rustedironcore.api.event.events.EntityTrackerRegisterEvent;
import net.minecraft.Entity;
import net.minecraft.Packet;
import net.minecraft.Packet23VehicleSpawn;
import net.minecraft.WorldClient;

public class EntityTrackerHandler
extends EventHandler<EntityTrackerRegisterEvent> {
    public Map<Predicate<Entity>, EntityTrackerEntry> trackerEntryMap = new HashMap<Predicate<Entity>, EntityTrackerEntry>();
    public Map<Predicate<Entity>, Function<Entity, Packet>> packetWriterMap = new HashMap<Predicate<Entity>, Function<Entity, Packet>>();
    public Map<Integer, EntitySupplier> packetReaderMap = new HashMap<Integer, EntitySupplier>();

    public Optional<EntityTrackerEntry> matchEntityTracker(Entity entity) {
        return this.trackerEntryMap.keySet().stream().filter(x -> x.test(entity)).findFirst().map(x -> this.trackerEntryMap.get(x));
    }

    public Optional<Packet> matchEntity(Entity entity) {
        return this.packetWriterMap.keySet().stream().filter(x -> x.test(entity)).findFirst().map(x -> this.packetWriterMap.get(x).apply(entity));
    }

    public Optional<EntitySupplier> matchPacket(int type) {
        return Optional.ofNullable(this.packetReaderMap.get(type));
    }

    @FunctionalInterface
    public static interface EntitySupplier {
        public Entity getEntity(WorldClient var1, double var2, double var4, double var6, Packet23VehicleSpawn var8);
    }

    public record EntityTrackerEntry(int blocksDistanceThreshold, int updateFrequency, boolean sendVelocityUpdates) {
    }
}

