/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.api.event.handler;

import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import moddedmite.rustedironcore.api.event.EventHandler;
import moddedmite.rustedironcore.api.event.events.DimensionRegisterEvent;
import moddedmite.rustedironcore.api.world.Dimension;
import moddedmite.rustedironcore.api.world.DimensionContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.WorldServer;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

public class DimensionHandler
extends EventHandler<DimensionRegisterEvent> {
    private final Map<Dimension, DimensionContext> contextMap = new HashMap<Dimension, DimensionContext>();
    private int index = 4;
    private final HashBiMap<Dimension, Integer> indexMap = HashBiMap.create();
    private final Map<Integer, Dimension> indexMapInverse = this.indexMap.inverse();

    public DimensionHandler() {
        this.indexMap.put((Object)Dimension.OVERWORLD, (Object)0);
        this.indexMap.put((Object)Dimension.NETHER, (Object)1);
        this.indexMap.put((Object)Dimension.END, (Object)2);
        this.indexMap.put((Object)Dimension.UNDERWORLD, (Object)3);
    }

    @ApiStatus.Internal
    public void registerDimensionInternal(Dimension dimension, DimensionContext context) {
        this.contextMap.put(dimension, context);
        this.indexMap.put((Object)dimension, (Object)this.index);
        ++this.index;
    }

    public Optional<Dimension> parseDimensionId(int dimensionId) {
        return Optional.ofNullable(Dimension.fromId(dimensionId));
    }

    public Optional<DimensionContext> getDimensionContext(int dimensionId) {
        return this.parseDimensionId(dimensionId).flatMap(this::getDimensionContext);
    }

    public Optional<DimensionContext> getDimensionContext(Dimension dimension) {
        return Optional.ofNullable(this.contextMap.get(dimension));
    }

    public int getTotalDimensionsCount() {
        return this.contextMap.size() + 4;
    }

    public int getCustomDimensionsCount() {
        return this.contextMap.size();
    }

    public int getIndex(Dimension dimension) {
        Integer i = (Integer)this.indexMap.get((Object)dimension);
        if (i == null) {
            throw new IllegalArgumentException("unregistered dimension: " + String.valueOf(dimension));
        }
        return i;
    }

    public Optional<Dimension> parseIndex(int index) {
        return Optional.ofNullable(this.indexMapInverse.get(index));
    }

    @Environment(value=EnvType.SERVER)
    public WorldServer getWorldServer(MinecraftServer server, Dimension dimension) {
        Integer index = (Integer)this.indexMap.get((Object)dimension);
        if (index == null) {
            throw new IllegalArgumentException("unregistered dimension: " + String.valueOf(dimension));
        }
        return server.worldServers[index];
    }
}

