/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.api.event.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import moddedmite.rustedironcore.api.event.EventHandler;
import moddedmite.rustedironcore.api.event.events.BiomeDecorationRegisterEvent;
import moddedmite.rustedironcore.api.world.Dimension;
import net.minecraft.BiomeDecorator;
import net.minecraft.BiomeGenBase;
import net.minecraft.World;
import net.minecraft.WorldGenerator;

public class BiomeDecorationHandler
extends EventHandler<BiomeDecorationRegisterEvent> {
    private final Map<Dimension, List<Setting>> DECORATION_MAP = new HashMap<Dimension, List<Setting>>();

    public void buildMap(Map<Dimension, List<SettingBuilder>> builderMap) {
        for (Map.Entry<Dimension, List<SettingBuilder>> entry : builderMap.entrySet()) {
            this.DECORATION_MAP.put(entry.getKey(), entry.getValue().stream().map(SettingBuilder::build).toList());
        }
    }

    public void onDecorate(Context context) {
        World world = context.world;
        Optional<Dimension> optional = this.DECORATION_MAP.keySet().stream().filter(x -> x.isOf(world)).findFirst();
        if (optional.isEmpty()) {
            return;
        }
        List<Setting> decorations = this.DECORATION_MAP.get(optional.get());
        decorations.forEach(x -> x.decorate(context));
    }

    public static Context context(World world, BiomeGenBase biome, BiomeDecorator biomeDecorator, Random rand, int blockX, int blockZ) {
        return new Context(world, biome, biomeDecorator, rand, blockX, blockZ);
    }

    public record Context(World world, BiomeGenBase biome, BiomeDecorator biomeDecorator, Random rand, int blockX, int blockZ) {
    }

    public record Setting(WorldGenerator decoration, Frequency frequency, HeightSupplier height) {
        public void decorate(Context context) {
            int blockX = context.blockX;
            int blockZ = context.blockZ;
            Random rand = context.rand;
            for (int i = 0; i < this.frequency.get(context); ++i) {
                int randomX = blockX + rand.nextInt(16) + 8;
                int randomZ = blockZ + rand.nextInt(16) + 8;
                int y = this.height.getDecorationHeight(context, randomX, randomZ);
                this.decoration.generate(context.world, rand, randomX, y, randomZ);
            }
        }
    }

    @FunctionalInterface
    public static interface HeightSupplier {
        public static final HeightSupplier SURFACE = (context, randomX, randomZ) -> context.world().getHeightValue(randomX, randomZ);
        public static final HeightSupplier COMMON = (context, randomX, randomZ) -> context.rand().nextInt(128);

        public int getDecorationHeight(Context var1, int var2, int var3);
    }

    @FunctionalInterface
    public static interface Frequency {
        public static final Frequency ONCE = context -> 1;

        public int get(Context var1);
    }

    public static class SettingBuilder {
        private final WorldGenerator decoration;
        private Frequency frequency = Frequency.ONCE;
        private HeightSupplier heightSupplier = HeightSupplier.COMMON;

        public SettingBuilder(WorldGenerator decoration) {
            this.decoration = decoration;
        }

        public SettingBuilder setAttempts(int attempts) {
            this.frequency = context -> attempts;
            return this;
        }

        public SettingBuilder setChance(int chance) {
            this.frequency = context -> context.rand().nextInt(chance) == 0 ? 1 : 0;
            return this;
        }

        public SettingBuilder setFrequency(Frequency frequency) {
            this.frequency = frequency;
            return this;
        }

        public SettingBuilder setSurface() {
            this.heightSupplier = HeightSupplier.SURFACE;
            return this;
        }

        public SettingBuilder setHeightSupplier(HeightSupplier heightSupplier) {
            this.heightSupplier = heightSupplier;
            return this;
        }

        public Setting build() {
            return new Setting(this.decoration, this.frequency, this.heightSupplier);
        }
    }
}

