/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.api.event.events;

import java.util.Map;
import java.util.Optional;
import moddedmite.rustedironcore.api.event.Handlers;
import moddedmite.rustedironcore.api.util.IdUtilExtra;
import moddedmite.rustedironcore.villager.VillagerSettings;
import net.minecraft.Item;
import net.minecraft.ResourceLocation;
import net.minecraft.Tuple;

public record TradingRegisterEvent(Map<Integer, Tuple> villagerStockList, Map<Integer, Tuple> blacksmithSellingList) {
    public VillagerSettings registerProfession(ResourceLocation texture) {
        return this.registerProfession(IdUtilExtra.getNextVillagerProfessionID(), texture);
    }

    public VillagerSettings registerProfession(int profession, ResourceLocation texture) {
        return this.registerProfession(profession, "villager.profession.unknown", texture);
    }

    public VillagerSettings registerProfession(int profession, String name, ResourceLocation texture) {
        return this.registerProfession(profession, new VillagerSettings(profession, name, texture));
    }

    public VillagerSettings registerProfession(int profession, VillagerSettings settings) {
        Handlers.Trading.registerProfession(profession, settings);
        return settings;
    }

    public Optional<VillagerSettings> getForProfession(int profession) {
        return Handlers.Trading.getForProfession(profession);
    }

    public void registerVillagerStock(Item item, int minCount, int maxCount) {
        int itemStackLimit = item.getItemStackLimit(0, 0);
        if (minCount > itemStackLimit) {
            minCount = itemStackLimit;
        }
        if (maxCount > itemStackLimit) {
            maxCount = itemStackLimit;
        }
        this.villagerStockList.put(item.itemID, new Tuple((Object)minCount, (Object)maxCount));
    }

    @Deprecated(since="1.3.6")
    public void registerVillagerStock(int id, Tuple data) {
        this.registerVillagerStock(Item.getItem((int)id), (Integer)data.getFirst(), (Integer)data.getSecond());
    }

    public void registerBlackSmithSelling(Item item, int minCount, int maxCount) {
        this.blacksmithSellingList.put(item.itemID, new Tuple((Object)minCount, (Object)maxCount));
    }

    @Deprecated(since="1.3.6")
    public void registerBlackSmithSelling(int id, Tuple data) {
        this.blacksmithSellingList.put(id, data);
    }
}

